/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;

public final class ClassReflectionIndex {
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private final Class<?> indexedClass;
    private final Map<String, Field> fields;
    private final Map<ParamList, Constructor<?>> constructors;
    private final Map<ParamNameList, Constructor<?>> constructorsByTypeName;
    private final Map<String, Map<ParamList, Map<Class<?>, Method>>> methods;
    private final Map<String, Map<ParamNameList, Map<String, Method>>> methodsByTypeName;
    private volatile Set<Method> classMethods;
    private static final ParamList EMPTY = new ParamList(new Class[0]);
    private static final ParamNameList EMPTY_NAMES = new ParamNameList(new String[0]);

    ClassReflectionIndex(Class<?> indexedClass, DeploymentReflectionIndex deploymentReflectionIndex) {
        this.deploymentReflectionIndex = deploymentReflectionIndex;
        this.indexedClass = indexedClass;
        Field[] declaredFields = indexedClass.getDeclaredFields();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            fields.put(field.getName(), field);
        }
        this.fields = fields;
        Method[] declaredMethods = indexedClass.getDeclaredMethods();
        HashMap methods = new HashMap();
        HashMap<String, Map<ParamNameList, Map<String, Method>>> methodsByTypeName = new HashMap<String, Map<ParamNameList, Map<String, Method>>>();
        for (Method method : declaredMethods) {
            if (method.getDeclaringClass() != Object.class) {
                method.setAccessible(true);
            }
            ClassReflectionIndex.addMethod(methods, method);
            ClassReflectionIndex.addMethodByTypeName(methodsByTypeName, method);
        }
        this.methods = methods;
        this.methodsByTypeName = methodsByTypeName;
        Constructor<?>[] constructorArray = indexedClass.getDeclaredConstructors();
        HashMap constructorsByTypeName = new HashMap();
        HashMap constructors = new HashMap();
        for (Constructor<?> constructor : constructorArray) {
            constructor.setAccessible(true);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            constructors.put(ClassReflectionIndex.createParamList(parameterTypes), constructor);
            constructorsByTypeName.put(ClassReflectionIndex.createParamNameList(parameterTypes), constructor);
        }
        this.constructorsByTypeName = constructorsByTypeName;
        this.constructors = constructors;
    }

    private static void addMethod(Map<String, Map<ParamList, Map<Class<?>, Method>>> methods, Method method) {
        Class<?>[] types;
        ParamList list;
        Map<Class<?>, Method> paramsMap;
        String name = method.getName();
        Map<ParamList, Map<Class<?>, Method>> nameMap = methods.get(name);
        if (nameMap == null) {
            nameMap = new HashMap();
            methods.put(name, nameMap);
        }
        if ((paramsMap = nameMap.get(list = ClassReflectionIndex.createParamList(types = method.getParameterTypes()))) == null) {
            paramsMap = new HashMap();
            nameMap.put(list, paramsMap);
        }
        if (!paramsMap.containsKey(method.getReturnType())) {
            paramsMap.put(method.getReturnType(), method);
        }
    }

    private static void addMethodByTypeName(Map<String, Map<ParamNameList, Map<String, Method>>> methodsByTypeName, Method method) {
        Class<?>[] types;
        ParamNameList list;
        Map<String, Method> paramsMap;
        String name = method.getName();
        Map<ParamNameList, Map<String, Method>> nameMap = methodsByTypeName.get(name);
        if (nameMap == null) {
            nameMap = new HashMap<ParamNameList, Map<String, Method>>();
            methodsByTypeName.put(name, nameMap);
        }
        if ((paramsMap = nameMap.get(list = ClassReflectionIndex.createParamNameList(types = method.getParameterTypes()))) == null) {
            paramsMap = new HashMap<String, Method>();
            nameMap.put(list, paramsMap);
        }
        if (!paramsMap.containsKey(method.getReturnType().getName())) {
            paramsMap.put(method.getReturnType().getName(), method);
        }
    }

    private static ParamNameList createParamNameList(Class<?>[] types) {
        if (types == null || types.length == 0) {
            return EMPTY_NAMES;
        }
        String[] strings = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            strings[i] = types[i].getName();
        }
        return new ParamNameList(strings);
    }

    private static ParamNameList createParamNameList(String[] typeNames) {
        return typeNames == null || typeNames.length == 0 ? EMPTY_NAMES : new ParamNameList(typeNames);
    }

    private static ParamList createParamList(Class<?>[] types) {
        return types == null || types.length == 0 ? EMPTY : new ParamList(types);
    }

    public Class<?> getIndexedClass() {
        return this.indexedClass;
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public Method getMethod(Class<?> returnType, String name, Class<?> ... paramTypes) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return null;
        }
        Map<Class<?>, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamList(paramTypes));
        if (paramsMap == null) {
            return null;
        }
        return paramsMap.get(returnType);
    }

    public Method getMethod(Method method) {
        return this.getMethod(method.getReturnType(), method.getName(), method.getParameterTypes());
    }

    public Method getMethod(String returnType, String name, String ... paramTypeNames) {
        Map<ParamNameList, Map<String, Method>> nameMap = this.methodsByTypeName.get(name);
        if (nameMap == null) {
            return null;
        }
        Map<String, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamNameList(paramTypeNames));
        if (paramsMap == null) {
            return null;
        }
        return paramsMap.get(returnType);
    }

    public Method getMethod(MethodIdentifier methodIdentifier) {
        Map<ParamNameList, Map<String, Method>> nameMap = this.methodsByTypeName.get(methodIdentifier.getName());
        if (nameMap == null) {
            return null;
        }
        Map<String, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamNameList(methodIdentifier.getParameterTypes()));
        if (paramsMap == null) {
            return null;
        }
        return paramsMap.get(methodIdentifier.getReturnType());
    }

    public Collection<Method> getMethods(String name, Class<?> ... paramTypes) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        Map<Class<?>, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamList(paramTypes));
        if (paramsMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(paramsMap.values());
    }

    public Collection<Method> getMethods(String name, String ... paramTypeNames) {
        Map<ParamNameList, Map<String, Method>> nameMap = this.methodsByTypeName.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        Map<String, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamNameList(paramTypeNames));
        if (paramsMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(paramsMap.values());
    }

    public Collection<Method> getAllMethods(String name) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map<Class<?>, Method> map : nameMap.values()) {
            methods.addAll(map.values());
        }
        return methods;
    }

    public Collection<Method> getAllMethods(String name, int paramCount) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map<Class<?>, Method> map : nameMap.values()) {
            for (Method method : map.values()) {
                if (method.getParameterCount() != paramCount) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public Collection<Method> getMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, Map<ParamList, Map<Class<?>, Method>>> entry : this.methods.entrySet()) {
            Map<ParamList, Map<Class<?>, Method>> nameMap = entry.getValue();
            for (Map<Class<?>, Method> map : nameMap.values()) {
                methods.addAll(map.values());
            }
        }
        return methods;
    }

    public Collection<Constructor<?>> getConstructors() {
        return Collections.unmodifiableCollection(this.constructors.values());
    }

    public Constructor<?> getConstructor(Class<?> ... paramTypes) {
        return this.constructors.get(ClassReflectionIndex.createParamList(paramTypes));
    }

    public Constructor<?> getConstructor(String ... paramTypeNames) {
        return this.constructorsByTypeName.get(ClassReflectionIndex.createParamNameList(paramTypeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getClassMethods() {
        if (this.classMethods == null) {
            ClassReflectionIndex classReflectionIndex = this;
            synchronized (classReflectionIndex) {
                if (this.classMethods == null) {
                    Class<?> clazz;
                    Set<Method> methods = ClassReflectionIndex.methodSet();
                    for (clazz = this.indexedClass; clazz != null; clazz = clazz.getSuperclass()) {
                        methods.addAll(this.deploymentReflectionIndex.getClassIndex(clazz).getMethods());
                    }
                    IdentityHashMap defaultMethodsByInterface = new IdentityHashMap();
                    HashSet<MethodIdentifier> foundMethods = new HashSet<MethodIdentifier>();
                    for (clazz = this.indexedClass; clazz != null; clazz = clazz.getSuperclass()) {
                        this.addDefaultMethods(this.indexedClass, foundMethods, defaultMethodsByInterface, clazz.getInterfaces());
                    }
                    for (Set methodSet : defaultMethodsByInterface.values()) {
                        methods.addAll(methodSet);
                    }
                    this.classMethods = methods;
                }
            }
        }
        return this.classMethods;
    }

    private boolean classContains(Class<?> clazz, MethodIdentifier methodIdentifier) {
        return clazz != null && (this.deploymentReflectionIndex.getClassIndex(clazz).getMethod(methodIdentifier) != null || this.classContains(clazz.getSuperclass(), methodIdentifier));
    }

    private void addDefaultMethods(Class<?> componentClass, Set<MethodIdentifier> foundMethods, Map<Class<?>, Set<Method>> defaultMethodsByInterface, Class<?>[] interfaces) {
        for (Class<?> i : interfaces) {
            if (!defaultMethodsByInterface.containsKey(i)) {
                Set<Method> set = ClassReflectionIndex.methodSet();
                defaultMethodsByInterface.put(i, set);
                ClassReflectionIndex interfaceIndex = this.deploymentReflectionIndex.getClassIndex(i);
                for (Method method : interfaceIndex.getMethods()) {
                    MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                    if ((method.getModifiers() & 0x409) != 1 || this.classContains(componentClass, identifier) || !foundMethods.add(identifier)) continue;
                    set.add(method);
                }
            }
            this.addDefaultMethods(componentClass, foundMethods, defaultMethodsByInterface, i.getInterfaces());
        }
    }

    private static Set<Method> methodSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private static final class ParamNameList {
        private final String[] types;
        private final int hashCode;

        ParamNameList(String[] types) {
            this.types = types;
            this.hashCode = Arrays.hashCode(types);
        }

        String[] getTypes() {
            return this.types;
        }

        public boolean equals(Object other) {
            return other instanceof ParamNameList && this.equals((ParamNameList)other);
        }

        public boolean equals(ParamNameList other) {
            return this == other || other != null && Arrays.equals(this.types, other.types);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class ParamList {
        private final Class<?>[] types;
        private final int hashCode;

        ParamList(Class<?>[] types) {
            this.types = types;
            this.hashCode = Arrays.hashCode(types);
        }

        Class<?>[] getTypes() {
            return this.types;
        }

        public boolean equals(Object other) {
            return other instanceof ParamList && this.equals((ParamList)other);
        }

        public boolean equals(ParamList other) {
            return this == other || other != null && Arrays.equals(this.types, other.types);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

