/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.persistence.jdbc;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.executors.BlockingResource;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfiguration;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=JDBCStoreConfiguration.class)
public class JDBCStore<K, V>
extends JdbcStringBasedStore<K, V> {
    private static final Logger LOGGER = Logger.getLogger(JDBCStore.class);
    private static final Runnable INTERRUPT = () -> Thread.currentThread().interrupt();
    private Executor executor;

    public CompletionStage<Void> start(InitializationContext context) {
        this.executor = context.getBlockingManager().asExecutor(((Object)((Object)this)).getClass().getSimpleName());
        return super.start(context);
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return this.blocking(this.tableOperations.publishEntries(() -> ((ConnectionFactory)this.connectionFactory).getConnection(), arg_0 -> ((ConnectionFactory)this.connectionFactory).releaseConnection(arg_0), segments, filter, includeValues));
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return this.blocking(this.tableOperations.publishKeys(() -> ((ConnectionFactory)this.connectionFactory).getConnection(), arg_0 -> ((ConnectionFactory)this.connectionFactory).releaseConnection(arg_0), segments, filter));
    }

    private <T> Flowable<T> blocking(Flowable<T> flowable) {
        if (Thread.currentThread().getThreadGroup() instanceof BlockingResource) {
            return flowable;
        }
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        ((Runnable)queue.take()).run();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), e);
                    }
                }
            }
        });
        Scheduler scheduler = Schedulers.from((Executor)new Executor(){

            @Override
            public void execute(Runnable task) {
                try {
                    queue.put(task);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, (boolean)false, (boolean)true);
        return flowable.subscribeOn(scheduler).unsubscribeOn(scheduler).observeOn(scheduler).doAfterTerminate(() -> queue.put(INTERRUPT));
    }
}

