/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.security.auth.client.AuthenticationContext;

class DefaultAuthenticationContextService
implements Service {
    static final ServiceName SERVICE_NAME = ElytronExtension.BASE_SERVICE_NAME.append(new String[]{"authentication-context-registration"});
    private final Supplier<AuthenticationContext> defaultAuthenticationContextSupplier;
    private final Consumer<AuthenticationContext> valueConsumer;
    private volatile AuthenticationContext originalAuthenticationContext;

    DefaultAuthenticationContextService(Supplier<AuthenticationContext> defaultAuthenticationContextSupplier, Consumer<AuthenticationContext> valueConsumer) {
        this.defaultAuthenticationContextSupplier = defaultAuthenticationContextSupplier;
        this.valueConsumer = valueConsumer;
    }

    public void start(StartContext context) throws StartException {
        AuthenticationContext authenticationContext = this.defaultAuthenticationContextSupplier.get();
        this.originalAuthenticationContext = DefaultAuthenticationContextService.setDefaultAuthenticationContext(authenticationContext);
        this.valueConsumer.accept(authenticationContext);
    }

    public void stop(StopContext context) {
        DefaultAuthenticationContextService.setDefaultAuthenticationContext(this.originalAuthenticationContext);
        this.originalAuthenticationContext = null;
    }

    private static final AuthenticationContext setDefaultAuthenticationContext(AuthenticationContext authenticationContext) {
        return SecurityActions.doPrivileged(() -> {
            ContextManager contextManager = AuthenticationContext.getContextManager();
            AuthenticationContext original = (AuthenticationContext)contextManager.getGlobalDefault();
            contextManager.setGlobalDefault((Contextual)authenticationContext);
            return original;
        });
    }
}

