/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CloseHandler {
    private Closeable closeable;
    private Runnable closeableHookCleanup;
    private final BiConsumer<Long, Handler<AsyncResult<Void>>> close;

    public CloseHandler(BiConsumer<Long, Handler<AsyncResult<Void>>> close) {
        this.close = close;
    }

    public void registerCloseHook(VertxInternal vertx) {
        this.registerCloseHook(arg_0 -> ((VertxInternal)vertx).addCloseHook(arg_0), arg_0 -> ((VertxInternal)vertx).removeCloseHook(arg_0));
    }

    public void registerCloseHook(ContextInternal context) {
        this.registerCloseHook(arg_0 -> ((ContextInternal)context).addCloseHook(arg_0), arg_0 -> ((ContextInternal)context).removeCloseHook(arg_0));
    }

    private synchronized void registerCloseHook(Consumer<Closeable> addCloseHook, Consumer<Closeable> removeCloseHook) {
        if (this.closeable == null) {
            this.closeable = ar -> {
                CloseHandler closeHandler = this;
                synchronized (closeHandler) {
                    if (this.closeable == null) {
                        ar.handle((AsyncResult)Future.succeededFuture());
                        return;
                    }
                    this.closeable = null;
                }
                this.close.accept(0L, (Handler<AsyncResult<Void>>)ar);
            };
            this.closeableHookCleanup = () -> {
                CloseHandler closeHandler = this;
                synchronized (closeHandler) {
                    if (this.closeable != null) {
                        removeCloseHook.accept(this.closeable);
                        this.closeable = null;
                    }
                }
            };
            addCloseHook.accept(this.closeable);
        }
    }

    public synchronized void unregisterCloseHook() {
        if (this.closeableHookCleanup != null) {
            this.closeableHookCleanup.run();
        }
    }

    public void close() {
        this.unregisterCloseHook();
        this.close.accept(0L, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.unregisterCloseHook();
        this.close.accept(0L, completionHandler);
    }

    public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) {
        this.unregisterCloseHook();
        this.close.accept(timeout, completionHandler);
    }
}

