/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.kafka.client.producer.RecordMetadata;
import io.vertx.kafka.client.producer.impl.KafkaProducerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

@VertxGen
public interface KafkaProducer<K, V>
extends WriteStream<KafkaProducerRecord<K, V>> {
    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config) {
        return KafkaProducerImpl.createShared(vertx, name, config);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config) {
        return KafkaProducerImpl.createShared(vertx, name, config);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options) {
        return KafkaProducerImpl.createShared(vertx, name, options);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, config, keyType, valueType);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, config, keySerializer, valueSerializer);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, config, keyType, valueType);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaProducerImpl.createShared(vertx, name, options, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, options, keyType, valueType);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Producer<K, V> producer) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, producer);
        return new KafkaProducerImpl<K, V>(vertx, stream);
    }

    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Map<String, String> config) {
        KafkaWriteStream stream = KafkaWriteStream.create(vertx, new HashMap<String, Object>(config));
        return new KafkaProducerImpl(vertx, stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Map<String, String> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, new HashMap<String, Object>(config), keySerializer, valueSerializer);
        return new KafkaProducerImpl<K, V>(vertx, stream).registerCloseHook();
    }

    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, new HashMap<String, Object>(config), keyType, valueType);
        return new KafkaProducerImpl<K, V>(vertx, stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Properties config) {
        KafkaWriteStream stream = KafkaWriteStream.create(vertx, config);
        return new KafkaProducerImpl(vertx, stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Properties config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, config, keySerializer, valueSerializer);
        return new KafkaProducerImpl<K, V>(vertx, stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, config, keyType, valueType);
        return new KafkaProducerImpl<K, V>(vertx, stream).registerCloseHook();
    }

    @Fluent
    public KafkaProducer<K, V> initTransactions(Handler<AsyncResult<Void>> var1);

    public Future<Void> initTransactions();

    @Fluent
    public KafkaProducer<K, V> beginTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> beginTransaction();

    @Fluent
    public KafkaProducer<K, V> commitTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> commitTransaction();

    @Fluent
    public KafkaProducer<K, V> abortTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> abortTransaction();

    @Fluent
    public KafkaProducer<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaProducer<K, V> setWriteQueueMaxSize(int var1);

    @Fluent
    public KafkaProducer<K, V> drainHandler(Handler<Void> var1);

    public Future<RecordMetadata> send(KafkaProducerRecord<K, V> var1);

    @Fluent
    public KafkaProducer<K, V> send(KafkaProducerRecord<K, V> var1, Handler<AsyncResult<RecordMetadata>> var2);

    @Fluent
    public KafkaProducer<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    @Fluent
    public KafkaProducer<K, V> flush(Handler<AsyncResult<Void>> var1);

    public Future<Void> flush();

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public Future<Void> close(long var1);

    public void close(long var1, Handler<AsyncResult<Void>> var3);

    @GenIgnore
    public KafkaWriteStream<K, V> asStream();

    @GenIgnore
    public Producer<K, V> unwrap();
}

