/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.dispatcher;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.View;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.NodeFactory;

public class ViewMembership
implements Membership {
    private final Address localAddress;
    private final View view;
    private final NodeFactory<Address> factory;

    public ViewMembership(Address localAddress, View view, NodeFactory<Address> factory) {
        this.localAddress = localAddress;
        this.view = view;
        this.factory = factory;
    }

    public boolean isCoordinator() {
        return this.localAddress.equals(this.view.getCoord());
    }

    public Node getCoordinator() {
        return this.factory.createNode((Object)this.view.getCoord());
    }

    public List<Node> getMembers() {
        ArrayList<Node> members = new ArrayList<Node>(this.view.size());
        for (Address address : this.view.getMembersRaw()) {
            Node member = this.factory.createNode((Object)address);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public int hashCode() {
        return this.view.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ViewMembership)) {
            return false;
        }
        ViewMembership membership = (ViewMembership)object;
        return this.view.equals((Object)membership.view);
    }

    public String toString() {
        return this.view.toString();
    }
}

