/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jberet.cdi.JobScoped;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.runtime.context.JobContextImpl;

public class JobScopedContextImpl
implements Context {
    static final JobScopedContextImpl INSTANCE = new JobScopedContextImpl();

    private JobScopedContextImpl() {
    }

    public static JobScopedContextImpl getInstance() {
        return INSTANCE;
    }

    public Class<? extends Annotation> getScope() {
        return JobScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        ConcurrentMap<Contextual<?>, ScopedInstance<?>> jobScopedBeans = this.getJobScopedBeans();
        ScopedInstance<Object> existing = (ScopedInstance<Object>)jobScopedBeans.get(contextual);
        if (existing == null) {
            Object instance = contextual.create(creationalContext);
            existing = jobScopedBeans.putIfAbsent(contextual, new ScopedInstance<Object>(instance, creationalContext));
            if (existing == null) {
                return (T)instance;
            }
            return existing.instance;
        }
        return existing.instance;
    }

    public <T> T get(Contextual<T> contextual) {
        ScopedInstance existing = (ScopedInstance)this.getJobScopedBeans().get(contextual);
        return existing == null ? null : (T)existing.instance;
    }

    public boolean isActive() {
        return ArtifactCreationContext.getCurrentArtifactCreationContext().jobContext != null;
    }

    public void destroy(Contextual<?> contextual) {
        ScopedInstance.destroy(this.getJobScopedBeans(), contextual);
    }

    private ConcurrentMap<Contextual<?>, ScopedInstance<?>> getJobScopedBeans() {
        JobContextImpl jobContext = ArtifactCreationContext.getCurrentArtifactCreationContext().jobContext;
        return jobContext.getScopedBeans();
    }

    public static final class ScopedInstance<T> {
        final T instance;
        final CreationalContext<T> creationalContext;

        public ScopedInstance(T instance, CreationalContext<T> creationalContext) {
            this.instance = instance;
            this.creationalContext = creationalContext;
        }

        public static void destroy(ConcurrentMap<Contextual<?>, ScopedInstance<?>> scopedBeans) {
            ScopedInstance.destroy(scopedBeans, null);
        }

        public static void destroy(ConcurrentMap<Contextual<?>, ScopedInstance<?>> scopedBeans, Contextual<?> contextual) {
            if (contextual == null) {
                if (scopedBeans.size() > 0) {
                    for (Map.Entry e : scopedBeans.entrySet()) {
                        Contextual key = (Contextual)e.getKey();
                        ScopedInstance value = (ScopedInstance)e.getValue();
                        key.destroy(value.instance, value.creationalContext);
                    }
                    scopedBeans.clear();
                }
            } else {
                ScopedInstance value = (ScopedInstance)scopedBeans.remove(contextual);
                if (value != null) {
                    contextual.destroy(value.instance, value.creationalContext);
                }
            }
        }
    }
}

