/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.BoundParameter;
import jakarta.websocket.DeploymentException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class BoundMethod {
    private final Method method;
    private final List<BoundParameter> parameters = new ArrayList<BoundParameter>();
    private final Set<Class> paramTypes = new HashSet<Class>();
    private final Class<?> messageType;
    private final boolean decoderRequired;
    private final long maxMessageSize;

    BoundMethod(Method method, Class<?> messageType, boolean decoderRequired, long maxMessageSize, BoundParameter ... params) throws DeploymentException {
        this.method = method;
        this.messageType = messageType;
        this.decoderRequired = decoderRequired;
        this.maxMessageSize = maxMessageSize;
        HashSet<Integer> allParams = new HashSet<Integer>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            allParams.add(i);
            this.paramTypes.add(method.getParameterTypes()[i]);
        }
        for (BoundParameter param : params) {
            this.parameters.add(param);
            allParams.removeAll(param.positions());
        }
        if (!allParams.isEmpty()) {
            boolean wrongAnnotation = false;
            for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                for (int j = 0; j < method.getParameterAnnotations()[i].length; ++j) {
                    Annotation annotation = method.getParameterAnnotations()[i][j];
                    if (!annotation.annotationType().getName().equals("jakarta.ws.rs.PathParam")) continue;
                    wrongAnnotation = true;
                }
            }
            if (wrongAnnotation) {
                throw JsrWebSocketMessages.MESSAGES.invalidParametersWithWrongAnnotation(method, allParams);
            }
            throw JsrWebSocketMessages.MESSAGES.invalidParameters(method, allParams);
        }
        method.setAccessible(true);
    }

    public Object invoke(Object instance, Map<Class<?>, Object> values) throws Exception {
        Object[] params = new Object[this.method.getParameterCount()];
        for (BoundParameter param : this.parameters) {
            param.populate(params, values);
        }
        try {
            return this.method.invoke(instance, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public boolean hasParameterType(Class<?> type) {
        return this.paramTypes.contains(type);
    }

    public Class<?> getMessageType() {
        return this.messageType;
    }

    public boolean isDecoderRequired() {
        return this.decoderRequired;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean overrides(Method method) {
        if (!method.getName().equals(this.method.getName())) {
            return false;
        }
        if (!method.getReturnType().isAssignableFrom(this.method.getReturnType())) {
            return false;
        }
        if (method.getParameterCount() != this.method.getParameterCount()) {
            return false;
        }
        if (method.getParameterCount() == 0) {
            return true;
        }
        Class<?>[] otherParameterTypes = this.method.getParameterTypes();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == otherParameterTypes[i]) continue;
            return false;
        }
        return true;
    }
}

