/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.store;

import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.AbstractFederatingContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.util.FastHashtable;

public class RelativeFederatingContext
extends AbstractFederatingContext {
    private final AbstractContext rootContext;
    private final CompositeName prefix;

    public RelativeFederatingContext(FastHashtable<String, Object> environment, AbstractContext rootContext, CompositeName prefix) {
        super(environment);
        Assert.checkNotNullParam((String)"rootContext", (Object)rootContext);
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        this.rootContext = rootContext;
        this.prefix = prefix;
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RelativeFederatingContext(new FastHashtable<String, Object>(this.getEnvironment()), this.rootContext, this.prefix);
        }
        return this.rootContext.lookup(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        this.rootContext.bind(this.decomposeName(this.getAbsoluteName(name)), obj);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.rootContext.rebind(this.decomposeName(this.getAbsoluteName(name)), obj);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        this.rootContext.unbind(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.rootContext.rename(this.decomposeName(this.getAbsoluteName(oldName)), this.decomposeName(this.getAbsoluteName(newName)));
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        return this.rootContext.list(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        return this.rootContext.listBindings(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        this.rootContext.destroySubcontext(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        return this.rootContext.createSubcontext(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RelativeFederatingContext(new FastHashtable<String, Object>(this.getEnvironment()), this.rootContext, this.prefix);
        }
        return this.rootContext.lookupLink(this.decomposeName(this.getAbsoluteName(name)));
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public NameParser getNativeNameParser() {
        return this.rootContext.getNativeNameParser();
    }

    private CompositeName getAbsoluteName(Name suffix) throws InvalidNameException {
        CompositeName compositeName = (CompositeName)this.prefix.clone();
        if (suffix instanceof CompositeName) {
            compositeName.addAll(suffix);
        } else {
            compositeName.add(suffix.toString());
        }
        return compositeName;
    }
}

