/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jacc;

import io.undertow.security.idm.Account;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JACCAuthorizationManager
implements AuthorizationManager {
    public static final AuthorizationManager INSTANCE = new JACCAuthorizationManager();

    public boolean isUserInRole(String roleName, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        return this.hasPermission(account, deployment, servletInfo, (Permission)new WebRoleRefPermission(servletInfo.getName(), roleName));
    }

    public boolean canAccessResource(List<SingleConstraintMatch> constraints, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        return this.hasPermission(account, deployment, servletInfo, (Permission)new WebResourcePermission(request));
    }

    public TransportGuaranteeType transportGuarantee(TransportGuaranteeType currentConnGuarantee, TransportGuaranteeType configuredRequiredGuarantee, HttpServletRequest request) {
        ProtectionDomain domain = new ProtectionDomain(null, null, null, null);
        String[] httpMethod = new String[]{request.getMethod()};
        String canonicalURI = this.getCanonicalURI(request);
        switch (currentConnGuarantee) {
            case NONE: {
                WebUserDataPermission permission = new WebUserDataPermission(canonicalURI, httpMethod, null);
                if (this.hasPermission(domain, (Permission)permission)) {
                    return TransportGuaranteeType.NONE;
                }
                permission = new WebUserDataPermission(canonicalURI, httpMethod, TransportGuaranteeType.CONFIDENTIAL.name());
                if (this.hasPermission(domain, (Permission)permission)) {
                    return TransportGuaranteeType.CONFIDENTIAL;
                }
                return TransportGuaranteeType.NONE;
            }
            case INTEGRAL: 
            case CONFIDENTIAL: {
                WebUserDataPermission permission = new WebUserDataPermission(canonicalURI, httpMethod, TransportGuaranteeType.CONFIDENTIAL.name());
                if (this.hasPermission(domain, (Permission)permission)) {
                    return TransportGuaranteeType.CONFIDENTIAL;
                }
                permission = new WebUserDataPermission(canonicalURI, httpMethod, TransportGuaranteeType.INTEGRAL.name());
                if (this.hasPermission(domain, (Permission)permission)) {
                    return TransportGuaranteeType.INTEGRAL;
                }
                return TransportGuaranteeType.REJECTED;
            }
        }
        return TransportGuaranteeType.REJECTED;
    }

    private String getCanonicalURI(HttpServletRequest request) {
        String canonicalURI = request.getRequestURI().substring(request.getContextPath().length());
        if (canonicalURI == null || canonicalURI.equals("/")) {
            canonicalURI = "";
        }
        return canonicalURI;
    }

    private boolean hasPermission(Account account, Deployment deployment, ServletInfo servletInfo, Permission permission) {
        CodeSource codeSource = servletInfo.getServletClass().getProtectionDomain().getCodeSource();
        ProtectionDomain domain = new ProtectionDomain(codeSource, null, null, this.getGrantedRoles(account, deployment));
        return this.hasPermission(domain, permission);
    }

    private boolean hasPermission(ProtectionDomain domain, Permission permission) {
        Policy policy = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(Policy::getPolicy) : Policy.getPolicy();
        return policy.implies(domain, permission);
    }

    private Principal[] getGrantedRoles(Account account, Deployment deployment) {
        if (account == null) {
            return new Principal[0];
        }
        HashSet roles = new HashSet(account.getRoles());
        Map principalVersusRolesMap = deployment.getDeploymentInfo().getPrincipalVersusRolesMap();
        roles.addAll(principalVersusRolesMap.getOrDefault(account.getPrincipal().getName(), Collections.emptySet()));
        Principal[] principals = new Principal[roles.size()];
        int index = 0;
        for (String role : roles) {
            principals[index++] = () -> role;
        }
        return principals;
    }
}

