/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.ejb.CreateException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.interceptors.EjbExceptionTransformingInterceptorFactories;
import org.jboss.as.ejb3.component.interceptors.SessionBeanHomeInterceptorFactory;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;

public class StatefulInitMethodInterceptor
implements Interceptor {
    public static final InterceptorFactory INSTANCE = new ImmediateInterceptorFactory((Interceptor)new StatefulInitMethodInterceptor());

    private StatefulInitMethodInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Method method = SessionBeanHomeInterceptorFactory.INIT_METHOD.get();
        Object[] params = SessionBeanHomeInterceptorFactory.INIT_PARAMETERS.get();
        SessionBeanHomeInterceptorFactory.INIT_METHOD.remove();
        SessionBeanHomeInterceptorFactory.INIT_PARAMETERS.remove();
        if (method != null) {
            InvocationType invocationType = (InvocationType)context.getPrivateData(InvocationType.class);
            try {
                context.putPrivateData(InvocationType.class, (Object)InvocationType.SFSB_INIT_METHOD);
                method.invoke(context.getTarget(), params);
            }
            catch (InvocationTargetException e) {
                if (CreateException.class.isAssignableFrom(e.getCause().getClass())) {
                    EjbExceptionTransformingInterceptorFactories.setCreateException((CreateException)e.getCause());
                }
                throw Interceptors.rethrow((Throwable)e.getCause());
            }
            finally {
                context.putPrivateData(InvocationType.class, (Object)invocationType);
            }
        }
        return context.proceed();
    }
}

