/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.invocationmetrics.InvocationMetrics;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.AbstractRuntimeMetricsHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.TimerResourceDefinition;
import org.jboss.as.ejb3.subsystem.deployment.TimerServiceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.ejb.client.SessionID;

public abstract class AbstractEJBComponentResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition COMPONENT_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("component-class-name", ModelType.STRING).setValidator((ParameterValidator)new StringLengthValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final StringListAttributeDefinition JNDI_NAMES = ((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"jndi-names").setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final StringListAttributeDefinition BUSINESS_LOCAL = ((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"business-local").setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final StringListAttributeDefinition BUSINESS_REMOTE = ((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"business-remote").setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final SimpleAttributeDefinition TIMEOUT_METHOD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout-method", ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final StringListAttributeDefinition ASYNC_METHODS = ((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"async-methods").setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final SimpleAttributeDefinition TRANSACTION_TYPE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("transaction-type", ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private static final AttributeDefinition EXECUTION_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("execution-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME, AttributeAccess.Flag.COUNTER_METRIC})).build();
    private static final AttributeDefinition INVOCATIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("invocations", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME, AttributeAccess.Flag.COUNTER_METRIC})).build();
    private static final AttributeDefinition PEAK_CONCURRENT_INVOCATIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("peak-concurrent-invocations", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    private static final AttributeDefinition WAIT_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("wait-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME, AttributeAccess.Flag.COUNTER_METRIC})).build();
    private static final AttributeDefinition METHODS = ((ObjectMapAttributeDefinition.Builder)((ObjectMapAttributeDefinition.Builder)ObjectMapAttributeDefinition.Builder.of((String)"methods", (ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.Builder.of((String)"complex", (AttributeDefinition[])new AttributeDefinition[]{EXECUTION_TIME, INVOCATIONS, WAIT_TIME}).build()).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition RUN_AS_ROLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("run-as-role", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final StringListAttributeDefinition DECLARED_ROLES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"declared-roles").setRequired(false)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setStorageRuntime()).build();
    private static final AttributeDefinition CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-size", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private static final AttributeDefinition PASSIVATED_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("passivated-count", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private static final AttributeDefinition TOTAL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("total-size", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition POOL_AVAILABLE_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-available-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition POOL_CREATE_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-create-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME, AttributeAccess.Flag.COUNTER_METRIC})).build();
    public static final SimpleAttributeDefinition POOL_CURRENT_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-current-size", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition POOL_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final SimpleAttributeDefinition POOL_REMOVE_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-remove-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME, AttributeAccess.Flag.COUNTER_METRIC})).build();
    public static final SimpleAttributeDefinition POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pool-max-size", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final ObjectTypeAttributeDefinition TIMER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("timer", new AttributeDefinition[]{TimerResourceDefinition.TIME_REMAINING, TimerResourceDefinition.NEXT_TIMEOUT, TimerResourceDefinition.CALENDAR_TIMER, TimerResourceDefinition.PERSISTENT, TimerResourceDefinition.INFO, new ObjectTypeAttributeDefinition.Builder(TimerResourceDefinition.SCHEDULE.getName(), TimerResourceDefinition.SCHEDULE.getValueTypes()).setSuffix("schedule").build()}).setStorageRuntime()).build();
    static final ObjectListAttributeDefinition TIMERS = ((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("timers", TIMER).setStorageRuntime()).build();
    final EJBComponentType componentType;

    public AbstractEJBComponentResourceDefinition(EJBComponentType componentType) {
        super(PathElement.pathElement((String)componentType.getResourceType()), EJB3Extension.getResourceDescriptionResolver(componentType.getResourceType()));
        this.componentType = componentType;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AbstractEJBComponentRuntimeHandler<?> handler = this.componentType.getRuntimeHandler();
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)COMPONENT_CLASS_NAME, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SECURITY_DOMAIN, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RUN_AS_ROLE, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DECLARED_ROLES, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)TRANSACTION_TYPE, handler);
        if (!this.componentType.equals((Object)EJBComponentType.MESSAGE_DRIVEN)) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)JNDI_NAMES, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)BUSINESS_LOCAL, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)BUSINESS_REMOTE, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ASYNC_METHODS, handler);
        }
        if (this.componentType.hasTimer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)TIMERS, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)TIMEOUT_METHOD, handler);
        }
        if (this.componentType.hasPool()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_AVAILABLE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_CREATE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_NAME, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_REMOVE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_CURRENT_SIZE, handler);
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)POOL_MAX_SIZE, handler, handler);
        }
        if (this.componentType.equals((Object)EJBComponentType.STATEFUL)) {
            resourceRegistration.registerMetric(CACHE_SIZE, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

                @Override
                protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                    StatefulSessionBeanCache<SessionID, StatefulSessionComponentInstance> cache = ((StatefulSessionComponent)component).getCache();
                    context.getResult().set(cache.getActiveCount());
                }
            });
            resourceRegistration.registerMetric(PASSIVATED_SIZE, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

                @Override
                protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                    StatefulSessionBeanCache<SessionID, StatefulSessionComponentInstance> cache = ((StatefulSessionComponent)component).getCache();
                    context.getResult().set(cache.getPassiveCount());
                }
            });
            resourceRegistration.registerMetric(TOTAL_SIZE, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

                @Override
                protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                    StatefulSessionBeanCache<SessionID, StatefulSessionComponentInstance> cache = ((StatefulSessionComponent)component).getCache();
                    context.getResult().set(cache.getActiveCount() + cache.getPassiveCount());
                }
            });
        }
        resourceRegistration.registerMetric(EXECUTION_TIME, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                context.getResult().set(component.getInvocationMetrics().getExecutionTime());
            }
        });
        resourceRegistration.registerMetric(INVOCATIONS, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                context.getResult().set(component.getInvocationMetrics().getInvocations());
            }
        });
        resourceRegistration.registerMetric(PEAK_CONCURRENT_INVOCATIONS, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                context.getResult().set(component.getInvocationMetrics().getPeakConcurrent());
            }
        });
        resourceRegistration.registerMetric(WAIT_TIME, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                context.getResult().set(component.getInvocationMetrics().getWaitTime());
            }
        });
        resourceRegistration.registerMetric(METHODS, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) {
                context.getResult().setEmptyObject();
                for (Map.Entry<String, InvocationMetrics.Values> entry : component.getInvocationMetrics().getMethods().entrySet()) {
                    InvocationMetrics.Values values = entry.getValue();
                    ModelNode result = new ModelNode();
                    result.get("execution-time").set(values.getExecutionTime());
                    result.get("invocations").set(values.getInvocations());
                    result.get("wait-time").set(values.getWaitTime());
                    context.getResult().get(entry.getKey()).set(result);
                }
            }
        });
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        if (this.componentType.hasTimer()) {
            AbstractEJBComponentRuntimeHandler<?> handler = this.componentType.getRuntimeHandler();
            resourceRegistration.registerSubModel(new TimerServiceResourceDefinition(handler));
        }
    }
}

