/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.LoaderLogging;
import org.hibernate.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.descriptor.java.JavaType;

public class LoaderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource session) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (LoaderLogging.LOADER_LOGGER.isTraceEnabled()) {
            LoaderLogging.LOADER_LOGGER.tracef("Locking `%s( %s )` in `%s` lock-mode", (Object)persister.getEntityName(), entry.getId(), (Object)requestedLockMode);
        }
        boolean cachingEnabled = persister.canWriteToCache();
        SoftLock lock = null;
        Object ck = null;
        try {
            if (cachingEnabled) {
                EntityDataAccess cache = persister.getCacheAccessStrategy();
                ck = cache.generateCacheKey(entry.getId(), persister, (SessionFactoryImplementor)session.getFactory(), session.getTenantIdentifier());
                lock = cache.lockItem(session, ck, entry.getVersion());
            }
            if (persister.isVersioned() && requestedLockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), false, session);
                entry.forceLocked(object, nextVersion);
            } else {
                persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, session);
            }
            entry.setLockMode(requestedLockMode);
            if (!cachingEnabled) return;
        }
        catch (Throwable throwable) {
            if (!cachingEnabled) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
    }

    public static Boolean getReadOnlyFromLoadQueryInfluencers(SharedSessionContractImplementor session) {
        return LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session.getLoadQueryInfluencers());
    }

    public static Boolean getReadOnlyFromLoadQueryInfluencers(LoadQueryInfluencers loadQueryInfluencers) {
        if (loadQueryInfluencers == null) {
            return null;
        }
        return loadQueryInfluencers.getReadOnly();
    }

    public static <K> K[] normalizeKeys(K[] keys, BasicValuedModelPart keyPart, SharedSessionContractImplementor session, SessionFactoryImplementor sessionFactory) {
        boolean coerce;
        assert (keys.getClass().isArray());
        JavaType<?> keyJavaType = keyPart.getJavaType();
        Class<?> keyClass = keyJavaType.getJavaTypeClass();
        if (keys.getClass().getComponentType().equals(keyClass)) {
            return keys;
        }
        ?[] typedArray = LoaderHelper.createTypedArray(keyClass, keys.length);
        boolean bl = coerce = !sessionFactory.getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        if (!coerce) {
            System.arraycopy(keys, 0, typedArray, 0, keys.length);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                typedArray[i] = keyJavaType.coerce(keys[i], session);
            }
        }
        return typedArray;
    }

    public static <X> X[] createTypedArray(Class<X> elementClass, int length) {
        return (Object[])Array.newInstance(elementClass, length);
    }

    public static <R, K> List<R> loadByArrayParameter(K[] idsToInitialize, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcOperation, JdbcParameter jdbcParameter, JdbcMapping arrayJdbcMapping, Object entityId, Object entityInstance, EntityMappingType rootEntityDescriptor, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        assert (jdbcOperation != null);
        assert (jdbcParameter != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(arrayJdbcMapping, idsToInitialize));
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, JdbcParametersList.singleton(jdbcParameter), jdbcParameterBindings);
        return session.getJdbcServices().getJdbcSelectExecutor().list(jdbcOperation, jdbcParameterBindings, new SingleIdExecutionContext(entityId, entityInstance, rootEntityDescriptor, readOnly, lockOptions, subSelectFetchableKeysHandler, session), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
    }
}

