/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexCompositeNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexRootBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexCompositeNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexObjectField;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexCompositeNodeType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexObjectFieldBuilder
extends AbstractElasticsearchIndexCompositeNodeBuilder
implements IndexObjectFieldBuilder,
ElasticsearchIndexNodeContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexCompositeNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final TreeNodeInclusion inclusion;
    private boolean multiValued = false;
    private ElasticsearchIndexObjectFieldReference reference;

    ElasticsearchIndexObjectFieldBuilder(AbstractElasticsearchIndexCompositeNodeBuilder parent, String relativeFieldName, TreeNodeInclusion inclusion, ObjectStructure structure) {
        super(new ElasticsearchIndexCompositeNodeType.Builder(structure));
        this.parent = parent;
        String parentAbsolutePath = parent.getAbsolutePath();
        this.absoluteFieldPath = parentAbsolutePath == null ? relativeFieldName : FieldPaths.compose((String)parentAbsolutePath, (String)relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.inclusion = inclusion;
    }

    public EventContext eventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new ElasticsearchIndexObjectFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexNodeCollector collector, ElasticsearchIndexCompositeNode parentNode, Map<String, ElasticsearchIndexField> staticChildrenByNameForParent, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        TreeMap<String, ElasticsearchIndexField> staticChildrenByName = new TreeMap<String, ElasticsearchIndexField>();
        ElasticsearchIndexObjectField fieldNode = new ElasticsearchIndexObjectField(parentNode, this.relativeFieldName, this.typeBuilder.build(), this.inclusion, this.multiValued, staticChildrenByName);
        staticChildrenByNameForParent.put(this.relativeFieldName, fieldNode);
        collector.collect(this.absoluteFieldPath, fieldNode);
        this.reference.setSchemaNode(fieldNode);
        DynamicType dynamicType = this.resolveSelfDynamicType(parentMapping.getDynamic());
        PropertyMapping mapping = ((ElasticsearchIndexCompositeNodeType)fieldNode.type()).createMapping(dynamicType);
        if (TreeNodeInclusion.INCLUDED.equals((Object)fieldNode.inclusion())) {
            parentMapping.addProperty(this.relativeFieldName, mapping);
        }
        this.contributeChildren(mapping, fieldNode, collector, staticChildrenByName);
    }

    @Override
    ElasticsearchIndexRootBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

