/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisConfigurationContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexRootBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.impl.IndexNamesRegistry;
import org.hibernate.search.backend.elasticsearch.index.DynamicMapping;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSimpleWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchBackendImpl
implements BackendImplementor,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<List<BeanReference<? extends ElasticsearchAnalysisConfigurer>>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis.configurer").asBeanReference(ElasticsearchAnalysisConfigurer.class).multivalued().build();
    private static final ConfigurationProperty<DynamicMapping> DYNAMIC_MAPPING = ConfigurationProperty.forKey((String)"dynamic_mapping").as(DynamicMapping.class, DynamicMapping::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.DYNAMIC_MAPPING).build();
    private static final OptionalConfigurationProperty<String> SCHEMA_MANAGEMENT_SETTINGS_FILE = ConfigurationProperty.forKey((String)"schema_management.settings_file").asString().build();
    private static final OptionalConfigurationProperty<String> SCHEMA_MANAGEMENT_MAPPING_FILE = ConfigurationProperty.forKey((String)"schema_management.mapping_file").asString().build();
    private final Optional<String> backendName;
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final ElasticsearchLinkImpl link;
    private final ElasticsearchSimpleWorkOrchestrator generalPurposeOrchestrator;
    private final ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder;
    private final TypeNameMapping typeNameMapping;
    private final IndexManagerBackendContext indexManagerBackendContext;
    private final IndexNamesRegistry indexNamesRegistry;

    ElasticsearchBackendImpl(Optional<String> backendName, EventContext eventContext, BackendThreads threads, ElasticsearchLinkImpl link, ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy, BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder, TypeNameMapping typeNameMapping, FailureHandler failureHandler, TimingSource timingSource) {
        this.backendName = backendName;
        this.eventContext = eventContext;
        this.threads = threads;
        this.link = link;
        this.generalPurposeOrchestrator = new ElasticsearchSimpleWorkOrchestrator("Elasticsearch general purpose orchestrator - " + eventContext.render(), link);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.typeFactoryProvider = typeFactoryProvider;
        this.userFacingGson = userFacingGson;
        this.indexLayoutStrategyHolder = indexLayoutStrategyHolder;
        this.typeNameMapping = typeNameMapping;
        this.indexManagerBackendContext = new IndexManagerBackendContext(this, eventContext, threads, link, userFacingGson, multiTenancyStrategy, (IndexLayoutStrategy)indexLayoutStrategyHolder.get(), typeNameMapping, failureHandler, timingSource, this.generalPurposeOrchestrator);
        this.indexNamesRegistry = new IndexNamesRegistry();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext.render() + "]";
    }

    public void start(BackendStartContext context) {
        this.threads.onStart(context.configurationPropertySource(), context.beanResolver(), context.threadPoolProvider());
        this.link.onStart(context.beanResolver(), context.configurationPropertySource());
        this.generalPurposeOrchestrator.start(context.configurationPropertySource());
    }

    public CompletableFuture<?> preStop() {
        return this.generalPurposeOrchestrator.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.generalPurposeOrchestrator);
            closer.push(ElasticsearchLinkImpl::onStop, (Object)this.link);
            closer.push(BeanHolder::close, this.indexLayoutStrategyHolder);
            closer.push(BackendThreads::onStop, (Object)this.threads);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Optional<String> name() {
        return this.backendName;
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T client(Class<T> clientClass) {
        return this.link.getClient().unwrap(clientClass);
    }

    public IndexManagerBuilder createIndexManagerBuilder(String hibernateSearchIndexName, String mappedTypeName, BackendBuildContext buildContext, BackendMapperContext backendMapperContext, ConfigurationPropertySource propertySource) {
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        IndexNames indexNames = this.createIndexNames(indexEventContext, hibernateSearchIndexName, mappedTypeName);
        ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.createAnalysisDefinitionRegistry(buildContext, indexEventContext, propertySource);
        return new ElasticsearchIndexManagerBuilder(this.indexManagerBackendContext, this.createIndexSchemaRootNodeBuilder(indexEventContext, backendMapperContext, indexNames, mappedTypeName, analysisDefinitionRegistry, this.customIndexSettings(buildContext, propertySource, indexEventContext), this.customIndexMappings(buildContext, propertySource, indexEventContext), (DynamicMapping)((Object)DYNAMIC_MAPPING.get(propertySource))), this.createDocumentMetadataContributors(mappedTypeName));
    }

    private IndexNames createIndexNames(EventContext indexEventContext, String hibernateSearchIndexName, String mappedTypeName) {
        IndexLayoutStrategy indexLayoutStrategy = (IndexLayoutStrategy)this.indexLayoutStrategyHolder.get();
        URLEncodedString writeAlias = IndexNames.encodeName(indexLayoutStrategy.createWriteAlias(hibernateSearchIndexName));
        URLEncodedString readAlias = IndexNames.encodeName(indexLayoutStrategy.createReadAlias(hibernateSearchIndexName));
        URLEncodedString primaryName = null;
        if (writeAlias == null || readAlias == null) {
            primaryName = IndexNames.encodeName(indexLayoutStrategy.createInitialElasticsearchIndexName(hibernateSearchIndexName));
        } else if (writeAlias.equals(readAlias)) {
            throw log.sameWriteAndReadAliases(writeAlias, indexEventContext);
        }
        URLEncodedString readName = readAlias != null ? readAlias : primaryName;
        URLEncodedString writeName = writeAlias != null ? writeAlias : primaryName;
        IndexNames indexNames = new IndexNames(hibernateSearchIndexName, writeName, writeAlias != null, readName, readAlias != null);
        this.indexNamesRegistry.register(indexNames);
        this.typeNameMapping.register(indexNames, mappedTypeName);
        return indexNames;
    }

    private ElasticsearchIndexRootBuilder createIndexSchemaRootNodeBuilder(EventContext indexEventContext, BackendMapperContext backendMapperContext, IndexNames indexNames, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, IndexSettings customIndexSettings, RootTypeMapping customIndexMapping, DynamicMapping dynamicMapping) {
        ElasticsearchIndexRootBuilder builder = new ElasticsearchIndexRootBuilder(this.typeFactoryProvider, indexEventContext, backendMapperContext, indexNames, mappedTypeName, analysisDefinitionRegistry, customIndexSettings, customIndexMapping, dynamicMapping);
        this.typeNameMapping.getIndexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        this.typeNameMapping.getImplicitFieldContributor().ifPresent(builder::addImplicitFieldContributor);
        this.multiTenancyStrategy.indexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        return builder;
    }

    private ElasticsearchAnalysisDefinitionRegistry createAnalysisDefinitionRegistry(BackendBuildContext buildContext, EventContext indexEventContext, ConfigurationPropertySource propertySource) {
        try {
            BeanResolver beanResolver = buildContext.beanResolver();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ElasticsearchAnalysisConfigurationContextImpl collector = new ElasticsearchAnalysisConfigurationContextImpl();
                    for (ElasticsearchAnalysisConfigurer configurer : (List)configurerHolder.get()) {
                        configurer.configure(collector);
                    }
                    ElasticsearchAnalysisDefinitionRegistry elasticsearchAnalysisDefinitionRegistry = new ElasticsearchAnalysisDefinitionRegistry(collector);
                    return elasticsearchAnalysisDefinitionRegistry;
                }
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), e, indexEventContext);
        }
    }

    private List<DocumentMetadataContributor> createDocumentMetadataContributors(String mappedTypeName) {
        ArrayList<DocumentMetadataContributor> contributors = new ArrayList<DocumentMetadataContributor>();
        this.typeNameMapping.getDocumentMetadataContributor(mappedTypeName).ifPresent(contributors::add);
        this.multiTenancyStrategy.documentMetadataContributor().ifPresent(contributors::add);
        return contributors;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IndexSettings customIndexSettings(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, EventContext indexEventContext) {
        Optional schemaManagementSettingsFile = (Optional)SCHEMA_MANAGEMENT_SETTINGS_FILE.get(propertySource);
        if (!schemaManagementSettingsFile.isPresent()) {
            return null;
        }
        String filePath = (String)schemaManagementSettingsFile.get();
        try (InputStream inputStream = buildContext.resourceResolver().locateResourceStream(filePath);){
            IndexSettings indexSettings;
            if (inputStream == null) {
                throw log.customIndexSettingsFileNotFound(filePath, indexEventContext);
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                indexSettings = (IndexSettings)this.userFacingGson.fromJson((Reader)reader, IndexSettings.class);
            }
            return indexSettings;
        }
        catch (IOException e) {
            throw log.customIndexSettingsErrorOnLoading(filePath, e.getMessage(), e, indexEventContext);
        }
        catch (JsonSyntaxException e) {
            throw log.customIndexSettingsJsonSyntaxErrors(filePath, e.getMessage(), (Exception)((Object)e), indexEventContext);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RootTypeMapping customIndexMappings(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, EventContext indexEventContext) {
        Optional schemaManagementMappingsFile = (Optional)SCHEMA_MANAGEMENT_MAPPING_FILE.get(propertySource);
        if (!schemaManagementMappingsFile.isPresent()) {
            return null;
        }
        String filePath = (String)schemaManagementMappingsFile.get();
        try (InputStream inputStream = buildContext.resourceResolver().locateResourceStream(filePath);){
            RootTypeMapping rootTypeMapping;
            if (inputStream == null) {
                throw log.customIndexMappingFileNotFound(filePath, indexEventContext);
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                rootTypeMapping = (RootTypeMapping)this.userFacingGson.fromJson((Reader)reader, RootTypeMapping.class);
            }
            return rootTypeMapping;
        }
        catch (IOException e) {
            throw log.customIndexMappingErrorOnLoading(filePath, e.getMessage(), e, indexEventContext);
        }
        catch (JsonSyntaxException e) {
            throw log.customIndexMappingJsonSyntaxErrors(filePath, e.getMessage(), (Exception)((Object)e), indexEventContext);
        }
    }
}

