/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MethodParameterDescriptor;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;

public interface MediatorConfiguration {
    public Shape shape();

    @Deprecated(since="4.8.0")
    public String getOutgoing();

    public List<String> getOutgoings();

    public List<String> getIncoming();

    public String methodAsString();

    public Method getMethod();

    public Class<?> getReturnType();

    public Consumption consumption();

    public Production production();

    public boolean usesReactiveStreams();

    public boolean usesBuilderTypes();

    public Acknowledgment.Strategy getAcknowledgment();

    public Merge.Mode getMerge();

    public boolean getBroadcast();

    public Bean<?> getBean();

    public int getNumberOfSubscriberBeforeConnecting();

    public boolean isBlocking();

    public String getWorkerPoolName();

    public boolean isBlockingExecutionOrdered();

    public Class<? extends Invoker> getInvokerClass();

    public Type getIngestedPayloadType();

    public Type getKeyType();

    public Type getValueType();

    public Class<? extends KeyValueExtractor> getKeyed();

    public MethodParameterDescriptor getParameterDescriptor();

    public boolean hasTargetedOutput();

    public static enum Consumption {
        STREAM_OF_MESSAGE,
        STREAM_OF_PAYLOAD,
        KEYED_MULTI,
        KEYED_MULTI_MESSAGE,
        MESSAGE,
        PAYLOAD,
        NONE;


        public boolean isMessageType() {
            return this == STREAM_OF_MESSAGE || this == KEYED_MULTI_MESSAGE || this == MESSAGE;
        }
    }

    public static enum Production {
        STREAM_OF_MESSAGE,
        STREAM_OF_PAYLOAD,
        INDIVIDUAL_PAYLOAD,
        INDIVIDUAL_MESSAGE,
        COMPLETION_STAGE_OF_PAYLOAD,
        COMPLETION_STAGE_OF_MESSAGE,
        UNI_OF_PAYLOAD,
        UNI_OF_MESSAGE,
        SPLIT_MULTI_OF_PAYLOAD,
        SPLIT_MULTI_OF_MESSAGE,
        NONE;


        public boolean isMessageType() {
            return this == STREAM_OF_MESSAGE || this == INDIVIDUAL_MESSAGE || this == COMPLETION_STAGE_OF_MESSAGE || this == UNI_OF_MESSAGE || this == SPLIT_MULTI_OF_MESSAGE;
        }
    }
}

