/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.FunctionExecutor;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricFunction;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.common.function.ExceptionFunction;

public class SingletonMetricExecutor
implements MetricExecutor<Singleton> {
    private final Function<String, ServiceName> serviceNameFactory;
    private final FunctionExecutorRegistry<Singleton> executors;

    public SingletonMetricExecutor(Function<String, ServiceName> serviceNameFactory, FunctionExecutorRegistry<Singleton> executors) {
        this.serviceNameFactory = serviceNameFactory;
        this.executors = executors;
    }

    public ModelNode execute(OperationContext context, Metric<Singleton> metric) throws OperationFailedException {
        ServiceName name = this.serviceNameFactory.apply(context.getCurrentAddressValue());
        FunctionExecutor executor = this.executors.get(name.append(new String[]{"singleton"}));
        return (ModelNode)(executor != null ? executor : new LegacySingletonFunctionExecutor(context, name)).execute((ExceptionFunction)new MetricFunction(Function.identity(), metric));
    }

    @Deprecated
    private static class LegacySingletonFunctionExecutor
    implements FunctionExecutor<Singleton> {
        private final Singleton singleton;

        LegacySingletonFunctionExecutor(OperationContext context, ServiceName name) {
            this.singleton = (Singleton)((Supplier)context.getServiceRegistry(false).getRequiredService(name).getService()).get();
        }

        public <R, E extends Exception> R execute(ExceptionFunction<Singleton, R, E> function) throws E {
            return (R)function.apply((Object)this.singleton);
        }
    }
}

