/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class CompoundRestriction
implements PasswordRestriction {
    private final List<PasswordRestriction> wrapped = new ArrayList<PasswordRestriction>();
    private final boolean must;

    public CompoundRestriction(boolean must) {
        this.must = must;
    }

    synchronized void add(PasswordRestriction restriction) {
        this.wrapped.add(restriction);
    }

    public List<PasswordRestriction> getRestrictions() {
        return Collections.unmodifiableList(this.wrapped);
    }

    @Override
    public synchronized String getRequirementMessage() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.wrapped.size(); ++i) {
            sb.append(this.wrapped.get(i).getRequirementMessage());
            if (i + 1 >= this.wrapped.size()) continue;
            sb.append(", ");
        }
        return this.must ? DomainManagementLogger.ROOT_LOGGER.passwordMustContainInfo(sb.toString()) : DomainManagementLogger.ROOT_LOGGER.passwordShouldContainInfo(sb.toString());
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        for (PasswordRestriction current : this.wrapped) {
            current.validate(userName, password);
        }
    }
}

