/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.jms.Connection;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ServerUtil {
    public static Process startServer(String artemisInstance, String serverName) throws Exception {
        return ServerUtil.startServer(artemisInstance, serverName, 0, 0);
    }

    public static Process startServer(String artemisInstance, String serverName, int id, int timeout) throws Exception {
        Process process = ServerUtil.internalStartServer(artemisInstance, serverName);
        if (timeout != 0) {
            ServerUtil.waitForServerToStart(id, timeout);
        }
        return process;
    }

    public static Process startServer(String artemisInstance, String serverName, String uri, int timeout) throws Exception {
        Process process = ServerUtil.internalStartServer(artemisInstance, serverName);
        if (timeout != 0) {
            ServerUtil.waitForServerToStart(uri, (long)timeout);
        }
        return process;
    }

    private static Process internalStartServer(String artemisInstance, String serverName) throws IOException, ClassNotFoundException {
        return ServerUtil.execute(artemisInstance, serverName, "run");
    }

    public static Process execute(String artemisInstance, String jobName, String ... args) throws IOException, ClassNotFoundException {
        try {
            boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().trim().startsWith("win");
            ArrayList<String> command = new ArrayList<String>();
            ProcessBuilder builder = null;
            if (IS_WINDOWS) {
                command.add("cmd");
                command.add("/c");
                command.add("artemis.cmd");
            } else {
                command.add("./artemis");
            }
            for (String arg : args) {
                command.add(arg);
            }
            builder = new ProcessBuilder(command);
            builder.directory(new File(artemisInstance + "/bin"));
            final Process process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    process.destroy();
                }
            });
            ProcessLogger outputLogger = new ProcessLogger(true, process.getInputStream(), jobName, false);
            outputLogger.start();
            ProcessLogger errorLogger = new ProcessLogger(true, process.getErrorStream(), jobName, true);
            errorLogger.start();
            return process;
        }
        catch (IOException e) {
            throw new IOException("Cannot start server at " + artemisInstance, e);
        }
    }

    public static boolean waitForServerToStart(int id, int timeout) throws InterruptedException {
        return ServerUtil.waitForServerToStart(id, null, null, timeout);
    }

    public static boolean waitForServerToStart(int id, String username, String password, int timeout) throws InterruptedException {
        return ServerUtil.waitForServerToStartOnPort(61616 + id, username, password, timeout);
    }

    public static boolean waitForServerToStartOnPort(int port, String username, String password, int timeout) throws InterruptedException {
        return ServerUtil.waitForServerToStart("tcp://localhost:" + port, username, password, (long)timeout);
    }

    public static boolean waitForServerToStart(String uri, long timeout) throws InterruptedException {
        return ServerUtil.waitForServerToStart(uri, null, null, timeout);
    }

    public static boolean waitForServerToStart(String uri, String username, String password, long timeout) throws InterruptedException {
        long realTimeout = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < realTimeout) {
            try (ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)uri, null);
                 Connection c = cf.createConnection(username, password);){
                System.out.println("server " + uri + " started");
            }
            catch (Exception e) {
                System.out.println("awaiting server " + uri + " start at ");
                Thread.sleep(500L);
                continue;
            }
            return true;
        }
        return false;
    }

    public static void killServer(Process server) throws Exception {
        ServerUtil.killServer(server, false);
    }

    public static void killServer(Process server, boolean forcibly) throws Exception {
        if (server != null) {
            System.out.println("**********************************");
            System.out.println("Killing server " + server);
            System.out.println("**********************************");
            if (forcibly) {
                server.destroyForcibly();
            } else {
                server.destroy();
            }
            server.waitFor();
            if (!forcibly) {
                Thread.sleep(1000L);
            }
        }
    }

    public static int getServer(Connection connection) {
        ClientSession session = ((ActiveMQConnection)connection).getInitialSession();
        TransportConfiguration transportConfiguration = session.getSessionFactory().getConnectorConfiguration();
        String port = (String)transportConfiguration.getParams().get("port");
        return Integer.valueOf(port) - 61616;
    }

    public static Connection getServerConnection(int server, Connection ... connections) {
        for (Connection connection : connections) {
            ClientSession session = ((ActiveMQConnection)connection).getInitialSession();
            TransportConfiguration transportConfiguration = session.getSessionFactory().getConnectorConfiguration();
            String port = (String)transportConfiguration.getParams().get("port");
            if (Integer.valueOf(port) != server + 61616) continue;
            return connection;
        }
        return null;
    }

    static class ProcessLogger
    extends Thread {
        private final InputStream is;
        private final String logName;
        private final boolean print;
        private final boolean sendToErr;

        ProcessLogger(boolean print, InputStream is, String logName, boolean sendToErr) throws ClassNotFoundException {
            this.is = is;
            this.print = print;
            this.logName = logName;
            this.sendToErr = sendToErr;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (!this.print) continue;
                    if (this.sendToErr) {
                        System.err.println(this.logName + "-err:" + line);
                        continue;
                    }
                    System.out.println(this.logName + "-out:" + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

