/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.NamingManager;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingContextFactory;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.Version;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;

public final class WildFlyRootContext
implements DirContext {
    private static final NameParser NAME_PARSER;
    private final FastHashtable<String, Object> environment;
    private final ProviderEnvironment providerEnvironment;
    private final List<NamingProviderFactory> namingProviderFactories;
    private final List<NamingContextFactory> namingContextFactories;

    public WildFlyRootContext(FastHashtable<String, Object> environment) throws NamingException {
        this(environment, WildFlyRootContext.secureGetContextClassLoader());
    }

    public WildFlyRootContext(FastHashtable<String, Object> environment, ClassLoader classLoader) throws NamingException {
        this(environment, WildFlyRootContext.loadServices(NamingProviderFactory.class, classLoader), WildFlyRootContext.loadServices(NamingContextFactory.class, classLoader));
    }

    static <T> List<T> loadServices(Class<T> type, ClassLoader classLoader) {
        return AccessController.doPrivileged(() -> {
            ArrayList list = new ArrayList();
            Iterator iterator = ServiceLoader.load(type, classLoader).iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        Object contextFactory = iterator.next();
                        list.add(contextFactory);
                    }
                }
                catch (ServiceConfigurationError error) {
                    Messages.log.serviceConfigFailed(error);
                    continue;
                }
                break;
            }
            list.trimToSize();
            return list;
        });
    }

    private WildFlyRootContext(FastHashtable<String, Object> environment, List<NamingProviderFactory> namingProviderFactories, List<NamingContextFactory> namingContextFactories) throws NamingException {
        this.environment = environment;
        this.namingProviderFactories = namingProviderFactories;
        this.namingContextFactories = namingContextFactories;
        ProviderEnvironment.Builder builder = new ProviderEnvironment.Builder();
        builder.populateFromEnvironment(environment);
        this.providerEnvironment = builder.build();
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(WildFlyRootContext::getContextClassLoader) : WildFlyRootContext.getContextClassLoader();
        return contextClassLoader == null ? WildFlyRootContext.class.getClassLoader() : contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderFactories, this.namingContextFactories);
        }
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookup(name);
        }
        return result.context.lookup(reparsedName.getName());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderFactories, this.namingContextFactories);
        }
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookup(name);
        }
        return result.context.lookup(reparsedName.getName());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.bind(name, obj);
        } else {
            result.context.bind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.bind(name, obj);
        } else {
            result.context.bind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rebind(name, obj);
        } else {
            result.context.rebind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rebind(name, obj);
        } else {
            result.context.rebind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.unbind(name);
        } else {
            result.context.unbind(reparsedName.getName());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.unbind(name);
        } else {
            result.context.unbind(reparsedName.getName());
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Assert.checkNotNullParam("oldName", oldName);
        Assert.checkNotNullParam("newName", newName);
        ReparsedName oldReparsedName = this.reparse(this.getNameParser().parse(oldName));
        ReparsedName newReparsedName = this.reparse(this.getNameParser().parse(newName));
        ContextResult result = this.getProviderContext(oldReparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rename(oldName, newName);
        } else {
            result.context.rename(oldReparsedName.getName(), newReparsedName.getName());
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Assert.checkNotNullParam("oldName", oldName);
        Assert.checkNotNullParam("newName", newName);
        ReparsedName oldReparsedName = this.reparse(oldName);
        ReparsedName newReparsedName = this.reparse(newName);
        ContextResult result = this.getProviderContext(oldReparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rename(oldName, newName);
        } else {
            result.context.rename(oldReparsedName.getName(), newReparsedName.getName());
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(reparsedName.getName()));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.destroySubcontext(name);
        } else {
            result.context.destroySubcontext(reparsedName.getName());
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.destroySubcontext(name);
        } else {
            result.context.destroySubcontext(reparsedName.getName());
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.createSubcontext(name);
        }
        return result.context.createSubcontext(reparsedName.getName());
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.createSubcontext(name);
        }
        return result.context.createSubcontext(reparsedName.getName());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookupLink(name);
        }
        return result.context.lookupLink(reparsedName.getName());
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookupLink(name);
        }
        return result.context.lookupLink(reparsedName.getName());
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getAttributes(name);
        }
        return ((DirContext)result.context).getAttributes(reparsedName.getName());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getAttributes(name);
        }
        return ((DirContext)result.context).getAttributes(reparsedName.getName());
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getAttributes(name, attrIds);
        }
        return ((DirContext)result.context).getAttributes(reparsedName.getName(), attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getAttributes(name, attrIds);
        }
        return ((DirContext)result.context).getAttributes(reparsedName.getName(), attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).modifyAttributes(name, mod_op, attrs);
        } else {
            ((DirContext)result.context).modifyAttributes(reparsedName.getName(), mod_op, attrs);
        }
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).modifyAttributes(name, mod_op, attrs);
        } else {
            ((DirContext)result.context).modifyAttributes(reparsedName.getName(), mod_op, attrs);
        }
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).modifyAttributes(name, mods);
        } else {
            ((DirContext)result.context).modifyAttributes(reparsedName.getName(), mods);
        }
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).modifyAttributes(name, mods);
        } else {
            ((DirContext)result.context).modifyAttributes(reparsedName.getName(), mods);
        }
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).bind(name, obj, attrs);
        } else {
            ((DirContext)result.context).bind(reparsedName.getName(), obj, attrs);
        }
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).bind(name, obj, attrs);
        } else {
            ((DirContext)result.context).bind(reparsedName.getName(), obj, attrs);
        }
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).rebind(name, obj, attrs);
        } else {
            ((DirContext)result.context).rebind(reparsedName.getName(), obj, attrs);
        }
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            ((DirContext)result.context).rebind(name, obj, attrs);
        } else {
            ((DirContext)result.context).rebind(reparsedName.getName(), obj, attrs);
        }
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).createSubcontext(name, attrs);
        }
        return ((DirContext)result.context).createSubcontext(reparsedName.getName(), attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).createSubcontext(name, attrs);
        }
        return ((DirContext)result.context).createSubcontext(reparsedName.getName(), attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getSchema(name);
        }
        return ((DirContext)result.context).getSchema(reparsedName.getName());
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getSchema(name);
        }
        return ((DirContext)result.context).getSchema(reparsedName.getName());
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getSchemaClassDefinition(name);
        }
        return ((DirContext)result.context).getSchemaClassDefinition(reparsedName.getName());
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).getSchemaClassDefinition(name);
        }
        return ((DirContext)result.context).getSchemaClassDefinition(reparsedName.getName());
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, matchingAttributes, attributesToReturn);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, matchingAttributes, attributesToReturn);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, matchingAttributes);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, matchingAttributes);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, filter, cons);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, filter, cons);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, filterExpr, filterArgs, cons);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        Assert.checkNotNullParam("name", name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return ((DirContext)result.context).search(name, filterExpr, filterArgs, cons);
        }
        return ((DirContext)result.context).search(reparsedName.getName(), filterExpr, filterArgs, cons);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser();
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this.getNameParser();
    }

    private NameParser getNameParser() {
        return NAME_PARSER;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("prefix", prefix);
        return this.composeName(this.getNameParser().parse(name), this.getNameParser().parse(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return prefix.addAll(name);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public FastHashtable<String, Object> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    private ContextResult getProviderContext(String nameScheme) throws NamingException {
        Context context;
        List<URI> providerUris = this.providerEnvironment.getProviderUris();
        boolean allEmpty = true;
        for (URI uri : providerUris) {
            String scheme = uri.getScheme();
            if (scheme == null || scheme.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            Context context2;
            for (NamingContextFactory contextFactory : this.namingContextFactories) {
                if (!contextFactory.supportsUriScheme(null, nameScheme)) continue;
                return new ContextResult(contextFactory.createRootContext(null, nameScheme, (FastHashtable<String, Object>)this.getEnvironment(), this.providerEnvironment), false);
            }
            if (nameScheme != null && (context2 = NamingManager.getURLContext(nameScheme, this.environment)) != null) {
                return new ContextResult(context2, true);
            }
            return new ContextResult(NamingUtils.emptyContext(this.getEnvironment()), false);
        }
        String uriScheme = nameScheme;
        boolean supportsUriSchemes = false;
        for (NamingProviderFactory providerFactory : this.namingProviderFactories) {
            supportsUriSchemes = true;
            for (URI providerUri : providerUris) {
                if (providerFactory.supportsUriScheme(providerUri.getScheme(), (FastHashtable<String, Object>)this.getEnvironment())) continue;
                supportsUriSchemes = false;
                uriScheme = providerUri.getScheme();
                break;
            }
            if (!supportsUriSchemes) continue;
            NamingProvider provider = providerFactory.createProvider((FastHashtable<String, Object>)this.getEnvironment(), this.providerEnvironment);
            for (NamingContextFactory contextFactory : this.namingContextFactories) {
                if (!contextFactory.supportsUriScheme(provider, nameScheme)) continue;
                return new ContextResult(contextFactory.createRootContext(provider, nameScheme, (FastHashtable<String, Object>)this.getEnvironment(), this.providerEnvironment), false);
            }
        }
        if (nameScheme != null && (context = NamingManager.getURLContext(nameScheme, this.environment)) != null) {
            return new ContextResult(context, true);
        }
        if (!supportsUriSchemes) {
            throw Messages.log.invalidURLSchemeName(uriScheme);
        }
        throw Messages.log.noProviderForUri(nameScheme);
    }

    ReparsedName reparse(Name origName) throws InvalidNameException {
        Name name = (Name)origName.clone();
        if (name.isEmpty()) {
            return new ReparsedName(null, name);
        }
        String first = name.get(0);
        int idx = first.indexOf(58);
        if (idx != -1) {
            String urlScheme = first.substring(0, idx);
            String segment = first.substring(idx + 1);
            name.remove(0);
            if (segment.length() > 0 || origName.size() > 1 && origName.get(1).length() > 0) {
                name.add(0, segment);
            }
            return new ReparsedName(urlScheme.isEmpty() ? null : urlScheme, name);
        }
        return new ReparsedName(null, name);
    }

    static {
        Version.getVersion();
        NAME_PARSER = CompositeName::new;
    }

    private class ContextResult {
        final Context context;
        final boolean oldStyle;

        private ContextResult(Context context, boolean oldStyle) {
            this.context = context;
            this.oldStyle = oldStyle;
        }
    }

    class ReparsedName {
        final String urlScheme;
        final Name name;

        ReparsedName(String urlScheme, Name name) {
            this.urlScheme = urlScheme;
            this.name = name;
        }

        public String getUrlScheme() {
            return this.urlScheme;
        }

        public Name getName() {
            return this.name;
        }

        boolean isEmpty() {
            return this.urlScheme == null && this.name.isEmpty();
        }
    }
}

