/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.connector.ByteBufferPool;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.SecurityActions;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowContainerProvider;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Extension;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.xnio.XnioWorker;

public class Bootstrap
implements ServletExtension {
    public static final String FILTER_NAME = "Undertow Web Socket Filter";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        if (info == null) {
            return;
        }
        Supplier<XnioWorker> worker = info.getWorker();
        ByteBufferPool buffers = info.getBuffers();
        if (buffers == null) {
            ServerWebSocketContainer defaultContainer = UndertowContainerProvider.getDefaultContainer();
            if (defaultContainer == null) {
                throw JsrWebSocketLogger.ROOT_LOGGER.bufferPoolWasNullAndNoDefault();
            }
            JsrWebSocketLogger.ROOT_LOGGER.bufferPoolWasNull();
            buffers = defaultContainer.getBufferPool();
        }
        ArrayList<ThreadSetupHandler> setup = new ArrayList<ThreadSetupHandler>();
        setup.add((ThreadSetupHandler)new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        InetSocketAddress bind = null;
        if (info.getClientBindAddress() != null) {
            bind = new InetSocketAddress(info.getClientBindAddress(), 0);
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionHandshake extensionHandshake : info.getExtensions()) {
            extensions.add(new ExtensionImpl(extensionHandshake.getName(), Collections.emptyList()));
        }
        final ServerWebSocketContainer container = new ServerWebSocketContainer(deploymentInfo.getClassIntrospecter(), servletContext.getClassLoader(), worker, buffers, setup, info.isDispatchToWorkerThread(), bind, info.getReconnectHandler(), extensions);
        try {
            for (Class<?> clazz : info.getAnnotatedEndpoints()) {
                container.addEndpoint(clazz);
            }
            for (ServerEndpointConfig serverEndpointConfig : info.getProgramaticEndpoints()) {
                container.addEndpoint(serverEndpointConfig);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new RuntimeException(deploymentException);
        }
        servletContext.setAttribute(ServerContainer.class.getName(), (Object)container);
        info.containerReady(container);
        SecurityActions.addContainer(deploymentInfo.getClassLoader(), (WebSocketContainer)container);
        deploymentInfo.addListener(Servlets.listener(WebSocketListener.class));
        deploymentInfo.addDeploymentCompleteListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                container.validateDeployment();
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
    }

    private static final class WebSocketListener
    implements ServletContextListener {
        private ServerWebSocketContainer container;

        private WebSocketListener() {
        }

        public void contextInitialized(ServletContextEvent sce) {
            this.container = (ServerWebSocketContainer)sce.getServletContext().getAttribute(ServerContainer.class.getName());
            FilterRegistration.Dynamic filter = sce.getServletContext().addFilter(Bootstrap.FILTER_NAME, JsrWebSocketFilter.class);
            sce.getServletContext().addListener(JsrWebSocketFilter.LogoutListener.class);
            filter.setAsyncSupported(true);
            if (!this.container.getConfiguredServerEndpoints().isEmpty()) {
                filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
            } else {
                this.container.setContextToAddFilter((ServletContextImpl)sce.getServletContext());
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            SecurityActions.removeContainer(sce.getServletContext().getClassLoader());
            if (this.container != null) {
                this.container.close();
            }
        }
    }
}

