/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.wildfly.installationmanager.Repository;

public class Channel {
    private final String name;
    private final List<Repository> repositories;
    private final Optional<URL> manifestUrl;
    private final Optional<String> manifestCoordinate;

    public Channel(String name, List<Repository> repositories, URL manifestUrl) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(repositories);
        Objects.requireNonNull(manifestUrl);
        this.name = name;
        this.repositories = Collections.unmodifiableList(repositories);
        this.manifestUrl = Optional.of(manifestUrl);
        this.manifestCoordinate = Optional.empty();
    }

    public Channel(String name, List<Repository> repositories, String manifestCoordinate) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(repositories);
        Objects.requireNonNull(manifestCoordinate);
        this.name = name;
        this.repositories = Collections.unmodifiableList(repositories);
        this.manifestUrl = Optional.empty();
        this.manifestCoordinate = Optional.of(manifestCoordinate);
    }

    public Channel(String name, List<Repository> repositories) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(repositories);
        this.name = name;
        this.repositories = Collections.unmodifiableList(repositories);
        this.manifestUrl = Optional.empty();
        this.manifestCoordinate = Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public Optional<URL> getManifestUrl() {
        return this.manifestUrl;
    }

    public Optional<String> getManifestCoordinate() {
        return this.manifestCoordinate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return Objects.equals(this.name, channel.name) && Objects.equals(this.repositories, channel.repositories) && Objects.equals(this.manifestUrl, channel.manifestUrl) && Objects.equals(this.manifestCoordinate, channel.manifestCoordinate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.repositories, this.manifestUrl, this.manifestCoordinate);
    }

    public String toString() {
        return "Channel{name='" + this.name + "', repositories=" + this.repositories + ", manifestUrl=" + this.manifestUrl + ", manifestCoordinate=" + this.manifestCoordinate + "}";
    }
}

