/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.EnumSet;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.http.oidc.Oidc;

class ProviderAttributeDefinitions {
    protected static final SimpleAttributeDefinition REALM_PUBLIC_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-public-key", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition AUTH_SERVER_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auth-server-url", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"provider-url"})).build();
    protected static final SimpleAttributeDefinition PROVIDER_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-url", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"auth-server-url"})).build();
    protected static final SimpleAttributeDefinition SSL_REQUIRED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-required", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("external"))).setValidator((ParameterValidator)EnumValidator.create(Oidc.SSLRequired.class, EnumSet.allOf(Oidc.SSLRequired.class)))).build();
    protected static final SimpleAttributeDefinition ALLOW_ANY_HOSTNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allow-any-hostname", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition DISABLE_TRUST_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disable-trust-manager", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CONNECTION_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-pool-size", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, true))).build();
    protected static final SimpleAttributeDefinition ENABLE_CORS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-cors", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEY_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-key-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CORS_MAX_AGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-max-age", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition CORS_ALLOWED_HEADERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-allowed-headers", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CORS_ALLOWED_METHODS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-allowed-methods", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CORS_EXPOSED_HEADERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-exposed-headers", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition EXPOSE_TOKEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expose-token", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition ALWAYS_REFRESH_TOKEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("always-refresh-token", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition REGISTER_NODE_AT_STARTUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register-node-at-startup", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition REGISTER_NODE_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register-node-period", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition TOKEN_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-store", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition PRINCIPAL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-attribute", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition AUTODETECT_BEARER_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("autodetect-bearer-only", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition IGNORE_OAUTH_QUERY_PARAMETER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ignore-oauth-query-parameter", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition CONFIDENTIAL_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("confidential-port", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(8443))).build();
    protected static final SimpleAttributeDefinition PROXY_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy-url", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition VERIFY_TOKEN_AUDIENCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verify-token-audience", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition SOCKET_TIMEOUT_MILLIS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-timeout-millis", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(-1L, true))).build();
    protected static final SimpleAttributeDefinition CONNECTION_TTL_MILLIS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-ttl-millis", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(-1L, true))).build();
    protected static final SimpleAttributeDefinition CONNECTION_TIMEOUT_MILLIS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-timeout-millis", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(-1L, true))).build();
    protected static final SimpleAttributeDefinition TOKEN_SIGNATURE_ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-signature-algorithm", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("RS256"))).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition AUTHENTICATION_REQUEST_FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-request-format", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("oauth2"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"oauth2", "request", "request_uri"}))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_ENCRYPTION_ALG_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-encryption-alg-value", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setRequires(new String[]{"request-object-encryption-enc-value"})).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_ENCRYPTION_ENC_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-encryption-enc-value", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setRequires(new String[]{"request-object-encryption-alg-value"})).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-algorithm", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("none"))).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_KEYSTORE_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-keystore-file", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_KEYSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-keystore-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_KEY_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-key-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_KEY_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-key-alias", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition REQUEST_OBJECT_SIGNING_KEYSTORE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-object-signing-keystore-type", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{REALM_PUBLIC_KEY, AUTH_SERVER_URL, PROVIDER_URL, TRUSTSTORE, TRUSTSTORE_PASSWORD, SSL_REQUIRED, CONFIDENTIAL_PORT, ALLOW_ANY_HOSTNAME, DISABLE_TRUST_MANAGER, CONNECTION_POOL_SIZE, ENABLE_CORS, CLIENT_KEYSTORE, CLIENT_KEYSTORE_PASSWORD, CLIENT_KEY_PASSWORD, CORS_MAX_AGE, CORS_ALLOWED_HEADERS, CORS_ALLOWED_METHODS, CORS_EXPOSED_HEADERS, EXPOSE_TOKEN, ALWAYS_REFRESH_TOKEN, REGISTER_NODE_AT_STARTUP, REGISTER_NODE_PERIOD, TOKEN_STORE, PRINCIPAL_ATTRIBUTE, AUTODETECT_BEARER_ONLY, IGNORE_OAUTH_QUERY_PARAMETER, PROXY_URL, VERIFY_TOKEN_AUDIENCE, SOCKET_TIMEOUT_MILLIS, CONNECTION_TTL_MILLIS, CONNECTION_TIMEOUT_MILLIS, TOKEN_SIGNATURE_ALGORITHM, AUTHENTICATION_REQUEST_FORMAT, REQUEST_OBJECT_SIGNING_ALGORITHM, REQUEST_OBJECT_ENCRYPTION_ENC_VALUE, REQUEST_OBJECT_ENCRYPTION_ALG_VALUE, REQUEST_OBJECT_SIGNING_KEYSTORE_FILE, REQUEST_OBJECT_SIGNING_KEYSTORE_PASSWORD, REQUEST_OBJECT_SIGNING_KEY_ALIAS, REQUEST_OBJECT_SIGNING_KEY_PASSWORD, REQUEST_OBJECT_SIGNING_KEYSTORE_TYPE};

    ProviderAttributeDefinitions() {
    }
}

