/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.FieldSetWriter;
import org.wildfly.clustering.marshalling.protostream.OffsetProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Reference;
import org.wildfly.clustering.marshalling.protostream.Writable;

public abstract class AbstractProtoStreamWriter
extends AbstractProtoStreamOperation
implements ProtoStreamWriter,
ProtobufTagMarshaller.WriteContext {
    private final TagWriter writer;
    private final int depth;
    private final ProtoStreamWriterContext context;

    protected AbstractProtoStreamWriter(ProtobufTagMarshaller.WriteContext context, ProtoStreamWriterContext writerContext) {
        super((ProtobufTagMarshaller.OperationContext)context);
        this.writer = context.getWriter();
        this.depth = context.depth();
        this.context = writerContext;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.context;
    }

    public TagWriter getWriter() {
        return this.writer;
    }

    public int depth() {
        return this.depth;
    }

    @Override
    public <T> FieldSetWriter<T> createFieldSetWriter(final Writable<T> writer, int startIndex) {
        final OffsetProtoStreamWriter offsetWriter = new OffsetProtoStreamWriter(this, startIndex);
        return new FieldSetWriter<T>(){

            @Override
            public void writeFields(T value) throws IOException {
                writer.writeTo(offsetWriter, value);
            }
        };
    }

    @Override
    public void writeAnyNoTag(Object value) throws IOException {
        Reference reference = this.context.getReference(value);
        Any any = new Any(reference != null ? reference : value);
        this.writeObjectNoTag(any);
        if (reference == null) {
            this.context.record(value);
        }
    }

    public void writeTag(int number, WireType wireType) throws IOException {
        this.writer.writeTag(number, wireType);
    }

    public void writeVarint32(int value) throws IOException {
        this.writer.writeVarint32(value);
    }

    public void writeVarint64(long value) throws IOException {
        this.writer.writeVarint64(value);
    }

    @Deprecated
    public void writeRawByte(byte value) throws IOException {
        this.writer.writeRawByte(value);
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.writer.writeRawBytes(value, offset, length);
    }

    @Deprecated
    public void writeRawBytes(ByteBuffer value) throws IOException {
        this.writer.writeRawBytes(value);
    }

    public void writeBool(int index, boolean value) throws IOException {
        this.writer.writeBool(index, value);
    }

    public void writeEnum(int index, int value) throws IOException {
        this.writer.writeEnum(index, value);
    }

    @Override
    @Deprecated
    public void writeInt32(int index, int value) throws IOException {
        this.writer.writeInt32(index, value);
    }

    @Override
    @Deprecated
    public void writeFixed32(int index, int value) throws IOException {
        this.writer.writeFixed32(index, value);
    }

    public void writeUInt32(int index, int value) throws IOException {
        this.writer.writeUInt32(index, value);
    }

    public void writeSInt32(int index, int value) throws IOException {
        this.writer.writeSInt32(index, value);
    }

    public void writeSFixed32(int index, int value) throws IOException {
        this.writer.writeSFixed32(index, value);
    }

    @Override
    @Deprecated
    public void writeInt64(int index, long value) throws IOException {
        this.writer.writeInt64(index, value);
    }

    @Override
    @Deprecated
    public void writeFixed64(int index, long value) throws IOException {
        this.writer.writeFixed64(index, value);
    }

    public void writeUInt64(int index, long value) throws IOException {
        this.writer.writeUInt64(index, value);
    }

    public void writeSInt64(int index, long value) throws IOException {
        this.writer.writeSInt64(index, value);
    }

    public void writeSFixed64(int index, long value) throws IOException {
        this.writer.writeSFixed64(index, value);
    }

    public void writeFloat(int index, float value) throws IOException {
        this.writer.writeFloat(index, value);
    }

    public void writeDouble(int index, double value) throws IOException {
        this.writer.writeDouble(index, value);
    }

    public void writeBytes(int index, byte[] value) throws IOException {
        this.writer.writeBytes(index, value);
    }

    public void writeBytes(int index, byte[] value, int offset, int length) throws IOException {
        this.writer.writeBytes(index, value, offset, length);
    }

    public void writeBytes(int index, ByteBuffer value) throws IOException {
        this.writer.writeBytes(index, value);
    }

    public void writeString(int index, String value) throws IOException {
        this.writer.writeString(index, value);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    static interface ProtoStreamWriterContext
    extends ProtoStreamOperation.Context {
        public Reference getReference(Object var1);

        public ProtoStreamWriterContext clone();

        public OptionalInt computeSize(Object var1, Function<Object, OptionalInt> var2);
    }

    static class DefaultProtoStreamWriterContext
    implements ProtoStreamWriterContext,
    Function<Object, Reference> {
        private final Map<Object, Reference> references = new IdentityHashMap<Object, Reference>(128);
        private int reference = 0;
        private final Map<Object, OptionalInt> sizes;

        DefaultProtoStreamWriterContext() {
            this(new IdentityHashMap<Object, OptionalInt>(128));
        }

        private DefaultProtoStreamWriterContext(Map<Object, OptionalInt> sizes) {
            this.sizes = sizes;
        }

        @Override
        public void record(Object object) {
            if (object != null) {
                this.references.computeIfAbsent(object, this);
            }
        }

        @Override
        public Reference getReference(Object object) {
            return object != null ? this.references.get(object) : null;
        }

        @Override
        public Reference apply(Object key) {
            return new Reference(this.reference++);
        }

        @Override
        public ProtoStreamWriterContext clone() {
            DefaultProtoStreamWriterContext context = new DefaultProtoStreamWriterContext(this.sizes);
            context.references.putAll(this.references);
            context.reference = this.reference;
            return context;
        }

        @Override
        public OptionalInt computeSize(Object object, Function<Object, OptionalInt> function) {
            return object instanceof Any ? function.apply(object) : this.sizes.computeIfAbsent(object, function);
        }
    }
}

