/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.resteasy.core;

import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.krazo.core.HttpCommunicationUnwrapper;

@Priority(value=1)
public class LibertyHttpCommunicationUnwrapper
implements HttpCommunicationUnwrapper {
    public boolean supports(Object obj) {
        if (obj instanceof HttpServletRequest) {
            try {
                Class.forName("com.ibm.wsspi.webcontainer.WebContainerRequestState", false, obj.getClass().getClassLoader());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public HttpServletRequest unwrapRequest(HttpServletRequest obj, Class<HttpServletRequest> type) {
        try {
            Class<?> requestStateClass = Class.forName("com.ibm.wsspi.webcontainer.WebContainerRequestState", false, obj.getClass().getClassLoader());
            Method getInstance = requestStateClass.getDeclaredMethod("getInstance", Boolean.TYPE);
            Object requestState = getInstance.invoke(null, false);
            Objects.requireNonNull(requestState, "Unable to retrieve current WebContainerRequestState instance");
            Method getCurrentThreadsIExtendedRequest = requestStateClass.getDeclaredMethod("getCurrentThreadsIExtendedRequest", new Class[0]);
            HttpServletRequest extendedRequest = (HttpServletRequest)getCurrentThreadsIExtendedRequest.invoke(requestState, new Object[0]);
            Objects.requireNonNull(extendedRequest, "Unable to retrieve current IExtendedRequest from Liberty");
            return extendedRequest;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Encountered exception when unwrapping Liberty request object", e);
        }
    }

    public HttpServletResponse unwrapResponse(HttpServletResponse obj, Class<HttpServletResponse> type) {
        return obj;
    }
}

