/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class IdentityHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 10929568968762L;
    private static final int DEFAULT_CAPACITY = 8;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.67f;
    private transient Object[] table;
    private transient int size;
    private transient int threshold;
    private final float loadFactor;
    private transient int modCount;

    public IdentityHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Can not have a negative size table!");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (!(loadFactor > 0.0f) || !(loadFactor <= 1.0f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than or equal to 1");
        }
        this.loadFactor = loadFactor;
        this.init(initialCapacity, loadFactor);
    }

    public IdentityHashSet(Set<? extends E> set) {
        if (set instanceof IdentityHashSet) {
            IdentityHashSet fast = (IdentityHashSet)set;
            this.table = (Object[])fast.table.clone();
            this.loadFactor = fast.loadFactor;
            this.size = fast.size;
            this.threshold = fast.threshold;
        } else {
            this.loadFactor = 0.67f;
            this.init(set.size(), this.loadFactor);
            this.addAll(set);
        }
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.threshold = (int)((float)c * loadFactor);
        if (initialCapacity > this.threshold && c < 0x40000000) {
            this.threshold = (int)((float)(c <<= 1) * loadFactor);
        }
        this.table = new Object[c];
    }

    public IdentityHashSet(int initialCapacity) {
        this(initialCapacity, 0.67f);
    }

    public IdentityHashSet() {
        this(8);
    }

    private static int hash(Object o) {
        int h = System.identityHashCode(o);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private int nextIndex(int index, int length) {
        index = index >= length - 1 ? 0 : index + 1;
        return index;
    }

    private static int index(int hashCode, int length) {
        return hashCode & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object entry) {
        int index;
        if (entry == null) {
            return false;
        }
        int hash = IdentityHashSet.hash(entry);
        int length = this.table.length;
        int start = index = IdentityHashSet.index(hash, length);
        do {
            Object e;
            if ((e = this.table[index]) == null) {
                return false;
            }
            if (entry != e) continue;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    @Override
    public boolean add(E entry) {
        Object e;
        int index;
        if (entry == null) {
            throw new NullPointerException("entry is null");
        }
        Object[] table = this.table;
        int hash = IdentityHashSet.hash(entry);
        int length = table.length;
        int start = index = IdentityHashSet.index(hash, length);
        while ((e = table[index]) != null) {
            if (e == entry) {
                return false;
            }
            if ((index = this.nextIndex(index, length)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        ++this.modCount;
        table[index] = entry;
        if (++this.size >= this.threshold) {
            this.resize(length);
        }
        return true;
    }

    private void resize(int from) {
        Object[] old;
        int newLength = from << 1;
        if (newLength > 0x40000000 || newLength <= from) {
            return;
        }
        Object[] newTable = new Object[newLength];
        for (Object e : old = this.table) {
            if (e == null) continue;
            int index = IdentityHashSet.index(IdentityHashSet.hash(e), newLength);
            while (newTable[index] != null) {
                index = this.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int size = collection.size();
        if (size == 0) {
            return false;
        }
        if (size > this.threshold) {
            int length;
            if (size > 0x40000000) {
                size = 0x40000000;
            }
            for (length = this.table.length; length < size; length <<= 1) {
            }
            this.resize(length);
        }
        boolean state = false;
        if (collection instanceof IdentityHashSet) {
            for (Object e : ((IdentityHashSet)collection).table) {
                if (e == null) continue;
                state |= this.add(e);
            }
        } else {
            for (E e : collection) {
                state |= this.add(e);
            }
        }
        return state;
    }

    @Override
    public boolean remove(Object o) {
        int start;
        if (o == null) {
            return false;
        }
        Object[] table = this.table;
        int length = table.length;
        int hash = IdentityHashSet.hash(o);
        int index = start = IdentityHashSet.index(hash, length);
        do {
            Object e;
            if ((e = table[index]) == null) {
                return false;
            }
            if (e != o) continue;
            table[index] = null;
            this.relocate(index);
            ++this.modCount;
            --this.size;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    private void relocate(int start) {
        Object[] table = this.table;
        int length = table.length;
        int current = this.nextIndex(start, length);
        Object e;
        while ((e = table[current]) != null) {
            int prefer = IdentityHashSet.index(IdentityHashSet.hash(e), length);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = this.nextIndex(current, length);
        }
        return;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    public IdentityHashSet<E> clone() {
        try {
            IdentityHashSet clone = (IdentityHashSet)super.clone();
            clone.table = (Object[])this.table.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T[] toScatteredArray(T[] dummy) {
        Object[] ret = (Object[])Array.newInstance(dummy.getClass().getComponentType(), this.table.length);
        System.arraycopy(this.table, 0, ret, 0, ret.length);
        return ret;
    }

    public E[] toArray(E[] target, int offs, int len) {
        assert (len <= this.size);
        Object[] table = this.table;
        int last = offs + len;
        int i = offs;
        int j = 0;
        while (i < last) {
            Object e = table[j];
            if (e != null) {
                target[i++] = e;
            }
            ++j;
        }
        return target;
    }

    public void printDebugStats() {
        int optimal = 0;
        int total = 0;
        int totalSkew = 0;
        int maxSkew = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Object e = this.table[i];
            if (e == null) continue;
            ++total;
            int target = IdentityHashSet.index(IdentityHashSet.hash(e), this.table.length);
            if (i == target) {
                ++optimal;
                continue;
            }
            int skew = Math.abs(i - target);
            if (skew > maxSkew) {
                maxSkew = skew;
            }
            totalSkew += skew;
        }
        System.out.println(" Size:             " + this.size);
        System.out.println(" Real Size:        " + total);
        System.out.println(" Optimal:          " + optimal + " (" + (float)optimal * 100.0f / (float)total + "%)");
        System.out.println(" Average Distance: " + (float)totalSkew / (float)(total - optimal));
        System.out.println(" Max Distance:     " + maxSkew);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(size, this.loadFactor);
        for (int i = 0; i < size; ++i) {
            this.putForCreate(s.readObject());
        }
        this.size = size;
    }

    private void putForCreate(E entry) {
        Object[] table = this.table;
        int hash = IdentityHashSet.hash(entry);
        int length = table.length;
        int index = IdentityHashSet.index(hash, length);
        Object e = table[index];
        while (e != null) {
            index = this.nextIndex(index, length);
            e = table[index];
        }
        table[index] = entry;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Object e : this.table) {
            if (e == null) continue;
            s.writeObject(e);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new IdentityHashSetIterator();
    }

    private class IdentityHashSetIterator
    implements Iterator<E> {
        private int next = 0;
        private int expectedCount;
        private int current;
        private boolean hasNext;
        Object[] table;

        private IdentityHashSetIterator() {
            this.expectedCount = IdentityHashSet.this.modCount;
            this.current = -1;
            this.table = IdentityHashSet.this.table;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            Object[] table = this.table;
            for (int i = this.next; i < table.length; ++i) {
                if (table[i] == null) continue;
                this.next = i;
                this.hasNext = true;
                return true;
            }
            this.next = table.length;
            return false;
        }

        @Override
        public E next() {
            if (IdentityHashSet.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.hasNext = false;
            return this.table[this.current];
        }

        @Override
        public void remove() {
            Object e;
            int current;
            if (IdentityHashSet.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            int delete = current = this.current;
            if (current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            this.next = delete;
            Object[] table = this.table;
            if (table != IdentityHashSet.this.table) {
                IdentityHashSet.this.remove(table[delete]);
                table[delete] = null;
                this.expectedCount = IdentityHashSet.this.modCount;
                return;
            }
            int length = table.length;
            int i = delete;
            table[delete] = null;
            --IdentityHashSet.this.size;
            while ((e = table[i = IdentityHashSet.this.nextIndex(i, length)]) != null) {
                int prefer = IdentityHashSet.index(IdentityHashSet.hash(e), length);
                if ((i >= prefer || prefer > delete && delete > i) && (prefer > delete || delete > i)) continue;
                if (i < current && current <= delete && table == IdentityHashSet.this.table) {
                    int remaining = length - current;
                    Object[] newTable = new Object[remaining];
                    System.arraycopy(table, current, newTable, 0, remaining);
                    this.table = newTable;
                    this.next = 0;
                }
                table[delete] = e;
                table[i] = null;
                delete = i;
            }
        }
    }
}

