/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.lang.ref.Cleaner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.LeakDetectorServiceContainer;
import org.jboss.msc.service.SecurityUtils;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public interface ServiceContainer
extends ServiceTarget,
ServiceRegistry {
    public void shutdown();

    public boolean isShutdown();

    public boolean isShutdownComplete();

    public void addTerminateListener(TerminateListener var1);

    public void awaitTermination() throws InterruptedException;

    public void awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public void awaitStability() throws InterruptedException;

    public boolean awaitStability(long var1, TimeUnit var3) throws InterruptedException;

    public void awaitStability(Set<? super ServiceController<?>> var1, Set<? super ServiceController<?>> var2) throws InterruptedException;

    public boolean awaitStability(long var1, TimeUnit var3, Set<? super ServiceController<?>> var4, Set<? super ServiceController<?>> var5) throws InterruptedException;

    public void dumpServices();

    public void dumpServices(PrintStream var1);

    public String getName();

    public static interface TerminateListener {
        public void handleTermination(Info var1);

        public static final class Info {
            private final long shutdownInitiated;
            private final long shutdownCompleted;

            Info(long shutdownInitiated, long shutdownCompleted) {
                this.shutdownInitiated = shutdownInitiated;
                this.shutdownCompleted = shutdownCompleted;
            }

            public long getShutdownInitiated() {
                return this.shutdownInitiated;
            }

            public long getShutdownCompleted() {
                return this.shutdownCompleted;
            }
        }
    }

    public static class Factory {
        private static final int MAX_THREADS_COUNT = SecurityUtils.getSystemProperty("jboss.msc.max.container.threads", 8);
        private static final Cleaner cleaner = Cleaner.create();

        private Factory() {
        }

        public static ServiceContainer create() {
            return Factory.create(null, Factory.calculateCoreSize(), 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(String name) {
            return Factory.create(name, Factory.calculateCoreSize(), 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return Factory.create(null, Factory.calculateCoreSize(coreSize), keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(String name, int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return Factory.create(name, Factory.calculateCoreSize(coreSize), keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(boolean autoShutdown) {
            return Factory.create(null, Factory.calculateCoreSize(), 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(String name, boolean autoShutdown) {
            return Factory.create(name, Factory.calculateCoreSize(), 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            return Factory.create(null, Factory.calculateCoreSize(coreSize), keepAliveTime, keepAliveTimeUnit, autoShutdown);
        }

        public static ServiceContainer create(String name, int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            ServiceContainerImpl container = new ServiceContainerImpl(name, Factory.calculateCoreSize(coreSize), keepAliveTime, keepAliveTimeUnit, autoShutdown);
            container.registerShutdownCleaner();
            container.registerMBeanCleaner();
            LeakDetectorServiceContainer retVal = new LeakDetectorServiceContainer(container);
            cleaner.register(retVal, container::shutdown);
            return retVal;
        }

        private static int calculateCoreSize() {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            return Factory.calculateCoreSize(Math.max(cpuCount << 1, 2));
        }

        private static int calculateCoreSize(int coreSize) {
            return Math.min(coreSize, MAX_THREADS_COUNT);
        }
    }
}

