/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.extensions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.orbspecific.CurrentImple;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;

public class AtomicTransaction {
    public static final int TOP_LEVEL = 0;
    public static final int NESTED = 1;
    protected ControlWrapper _theAction;
    protected Status _theStatus;
    protected int _timeout;

    public AtomicTransaction() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"AtomicTransaction::AtomicTransaction ()");
        }
        this._theAction = null;
        this._theStatus = Status.StatusNoTransaction;
        this._timeout = this.get_timeout();
    }

    public void finalize() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"AtomicTransaction.finalize ()");
        }
        if (this._theAction != null && this.getStatus() == Status.StatusActive) {
            jtsLogger.i18NLogger.warn_extensions_atscope("AtomicTransaction.finalize", this.get_uid());
            String name = null;
            try {
                name = this.get_transaction_name();
            }
            catch (SystemException ex) {
                jtsLogger.i18NLogger.warn_extensions_namefail(ex);
            }
            try {
                this.rollback();
            }
            catch (NoTransaction e) {
                jtsLogger.i18NLogger.warn_extensions_abortfailnoexist(name);
            }
            catch (Exception e) {
                jtsLogger.i18NLogger.warn_extensions_abortfail(name);
            }
        }
    }

    public String get_transaction_name() throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"AtomicTransaction::get_transaction_name ()");
        }
        if (this._theAction != null) {
            try {
                return this._theAction.get_transaction_name();
            }
            catch (SystemException e) {
                jtsLogger.i18NLogger.warn_extensions_atunavailable("AtomicTransaction.get_transaction_name");
                throw e;
            }
        }
        throw new UNKNOWN(30001, CompletionStatus.COMPLETED_NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws SubtransactionsUnavailable, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"AtomicTransaction::begin ()");
        }
        CurrentImple current = OTSImpleManager.current();
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction != null) {
                throw new INVALID_TRANSACTION(60003, CompletionStatus.COMPLETED_NO);
            }
            current.begin();
            this._theAction = current.getControlWrapper();
        }
        this._theStatus = current.get_status();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::begin create " + String.valueOf(this._theAction)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean report_heuristics) throws NoTransaction, HeuristicMixed, HeuristicHazard, WrongTransaction, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::commit ( " + report_heuristics + " ) for " + String.valueOf(this._theAction)));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new NoTransaction();
            }
        }
        if (!this.validTransaction()) {
            throw new WrongTransaction();
        }
        CurrentImple current = OTSImpleManager.current();
        try {
            current.commit(report_heuristics);
            this._theStatus = Status.StatusCommitted;
        }
        catch (NoTransaction e) {
            this._theStatus = Status.StatusNoTransaction;
            throw e;
        }
        catch (HeuristicMixed e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        catch (HeuristicHazard e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            this._theStatus = Status.StatusRolledBack;
            throw e;
        }
        catch (SystemException e) {
            this._theStatus = this.getStatus();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws NoTransaction, WrongTransaction, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::rollback for " + String.valueOf(this._theAction)));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new NoTransaction();
            }
        }
        if (!this.validTransaction()) {
            throw new WrongTransaction();
        }
        CurrentImple current = OTSImpleManager.current();
        try {
            current.rollback();
            this._theStatus = Status.StatusRolledBack;
        }
        catch (NoTransaction e) {
            this._theStatus = Status.StatusNoTransaction;
            throw e;
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            this._theStatus = Status.StatusRolledBack;
        }
        catch (SystemException e) {
            this._theStatus = this.getStatus();
            throw e;
        }
    }

    public void set_timeout(int seconds) throws SystemException {
        CurrentImple current;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::set_timeout ( " + seconds + " )"));
        }
        if ((current = OTSImpleManager.current()) == null) {
            throw new UNKNOWN();
        }
        current.set_timeout(seconds);
    }

    public int get_timeout() throws SystemException {
        CurrentImple current = OTSImpleManager.current();
        if (current != null) {
            int val = current.get_timeout();
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((Object)("AtomicTransaction::get_timeout returning " + val));
            }
            return val;
        }
        throw new UNKNOWN();
    }

    public int getTimeout() throws SystemException {
        return this._timeout;
    }

    public PropagationContext get_txcontext() throws Inactive, SystemException {
        if (this._theAction == null) {
            throw new Inactive();
        }
        try {
            return this._theAction.get_coordinator().get_txcontext();
        }
        catch (NullPointerException ex) {
            throw new Inactive();
        }
        catch (Exception e) {
            throw new BAD_OPERATION(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryCoordinator registerResource(Resource r) throws Inactive, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::registerResource ( " + String.valueOf(r) + " )"));
        }
        Object rc = null;
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new Inactive();
            }
        }
        return this._theAction.register_resource(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubtranAware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::registerSubtranAware ( " + String.valueOf(r) + " )"));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new Inactive();
            }
        }
        this._theAction.register_subtran_aware(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::registerSynchronization ( " + String.valueOf(sync) + " )"));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new Inactive();
            }
        }
        this._theAction.register_synchronization(sync);
    }

    public Control control() throws NoTransaction, SystemException {
        if (this._theAction == null) {
            throw new NoTransaction();
        }
        try {
            return this._theAction.get_control();
        }
        catch (Unavailable ex) {
            throw new NoTransaction();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AtomicTransaction) {
            try {
                AtomicTransaction tx2 = (AtomicTransaction)obj;
                ControlWrapper txControl = tx2._theAction;
                if (this._theAction == null && txControl == null) {
                    return true;
                }
                if (this._theAction == null) {
                    return false;
                }
                return this._theAction.equals(txControl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws NoTransaction, WrongTransaction, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::suspend called for " + String.valueOf(this._theAction)));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new NoTransaction();
            }
        }
        if (!this.validTransaction()) {
            throw new WrongTransaction();
        }
        status = this._theStatus;
        synchronized (status) {
            this._theAction = OTSImpleManager.current().suspendWrapper();
            if (this._theAction == null) {
                this._theStatus = Status.StatusNoTransaction;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws InvalidControl, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::resume called for " + String.valueOf(this._theAction)));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new InvalidControl();
            }
        }
        OTSImpleManager.current().resumeWrapper(this._theAction);
    }

    public Status get_status() throws SystemException {
        this._theStatus = this.getStatus();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::get_status called for " + String.valueOf(this._theAction) + " returning " + Utility.stringStatus(this._theStatus)));
        }
        return this._theStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackOnly() throws SystemException, NoTransaction {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::rollbackOnly called for " + String.valueOf(this._theAction)));
        }
        Status status = this._theStatus;
        synchronized (status) {
            if (this._theAction == null) {
                throw new NoTransaction();
            }
        }
        this._theAction.preventCommit();
    }

    public int hashCode() {
        try {
            return this._theAction.hash_transaction();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Uid get_uid() {
        if (this._theAction != null) {
            return this._theAction.get_uid();
        }
        return Uid.nullUid();
    }

    protected final boolean validTransaction() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("AtomicTransaction::validTransaction called for " + String.valueOf(this._theAction)));
        }
        CurrentImple current = OTSImpleManager.current();
        boolean valid = false;
        try {
            ControlWrapper currentTransaction = current.getControlWrapper();
            if (currentTransaction == null) {
                jtsLogger.i18NLogger.warn_extensions_atnovalidtx("AtomicTransaction.validTransaction");
                return false;
            }
            valid = this._theAction.equals(currentTransaction);
            if (!valid) {
                String transactionName = this.get_transaction_name();
                String currentTransactionName = currentTransaction.get_transaction_name();
                jtsLogger.i18NLogger.warn_extensions_atoutofseq("AtomicTransaction", transactionName);
                jtsLogger.i18NLogger.warn_extensions_atwillabort(currentTransactionName);
                try {
                    this._theAction.rollback();
                }
                catch (Exception ex) {
                    jtsLogger.i18NLogger.warn_extensions_atcannotabort("AtomicTransaction", transactionName);
                }
            }
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_extensions_atgenerror("AtomicTransaction", e);
        }
        return valid;
    }

    protected AtomicTransaction(ControlWrapper tx2) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"AtomicTransaction::AtomicTransaction ()");
        }
        this._theAction = tx2;
        this._theStatus = this.getStatus();
        this._timeout = this.get_timeout();
    }

    protected final Status getStatus() {
        if (this._theStatus != null) {
            switch (this._theStatus.value()) {
                case 3: 
                case 4: 
                case 9: {
                    return this._theStatus;
                }
            }
        }
        Status stat = Status.StatusUnknown;
        if (this._theAction != null) {
            stat = this._theAction.get_status();
        }
        return stat;
    }
}

