/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.AbstractHttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class HttpsListenerResourceDefinition
extends AbstractHttpListenerResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"https-listener");
    protected static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, false).setAlternatives(new String[]{"security-realm", "verify-client", "enabled-cipher-suites", "enabled-protocols", "ssl-session-cache-size", "ssl-session-timeout"})).setCapabilityReference(LISTENER_CAPABILITY, "org.wildfly.security.ssl-context", new AttributeDefinition[0])).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();
    protected static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, false).setAlternatives(new String[]{"ssl-context"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).build();
    protected static final OptionAttributeDefinition VERIFY_CLIENT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"verify-client", (Option)Options.SSL_CLIENT_AUTH_MODE).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)EnumValidator.create(SslClientAuthMode.class))).setDefaultValue(new ModelNode(SslClientAuthMode.NOT_REQUESTED.name()))).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setAlternatives(new String[]{"ssl-context"})).build();
    protected static final OptionAttributeDefinition ENABLED_CIPHER_SUITES = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enabled-cipher-suites", (Option)Options.SSL_ENABLED_CIPHER_SUITES).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setAlternatives(new String[]{"ssl-context"})).build();
    protected static final OptionAttributeDefinition ENABLED_PROTOCOLS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enabled-protocols", (Option)Options.SSL_ENABLED_PROTOCOLS).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setAlternatives(new String[]{"ssl-context"})).build();
    protected static final OptionAttributeDefinition ENABLE_SPDY = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enable-spdy", (Option)UndertowOptions.ENABLE_SPDY).setRequired(false)).setDeprecated(ModelVersion.create((int)3, (int)2))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    public static final OptionAttributeDefinition SSL_SESSION_CACHE_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"ssl-session-cache-size", (Option)Options.SSL_SERVER_SESSION_CACHE_SIZE).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setRequired(false)).setAllowExpression(true)).setAlternatives(new String[]{"ssl-context"})).build();
    public static final OptionAttributeDefinition SSL_SESSION_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"ssl-session-timeout", (Option)Options.SSL_SERVER_SESSION_TIMEOUT).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRequired(false)).setAllowExpression(true)).setAlternatives(new String[]{"ssl-context"})).build();
    static final List<AttributeDefinition> ATTRIBUTES = List.of(SSL_CONTEXT, SECURITY_REALM, VERIFY_CLIENT, ENABLED_CIPHER_SUITES, ENABLED_PROTOCOLS, ENABLE_SPDY, SSL_SESSION_CACHE_SIZE, SSL_SESSION_TIMEOUT);

    HttpsListenerResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver("listener")).setCapabilities(new RuntimeCapability[]{HTTP_UPGRADE_REGISTRY_CAPABILITY}), new HttpsListenerAdd());
    }

    public Collection<AttributeDefinition> getAttributes() {
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>(ListenerResourceDefinition.ATTRIBUTES.size() + AbstractHttpListenerResourceDefinition.ATTRIBUTES.size() + ATTRIBUTES.size());
        attributes.addAll(ListenerResourceDefinition.ATTRIBUTES);
        attributes.addAll(AbstractHttpListenerResourceDefinition.ATTRIBUTES);
        attributes.addAll(ATTRIBUTES);
        return Collections.unmodifiableCollection(attributes);
    }
}

