/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.List;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationSerializer;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;

@BuiltBy(value=RemoteStoreConfigurationBuilder.class)
@ConfigurationFor(value=RemoteStore.class)
@SerializedWith(value=RemoteStoreConfigurationSerializer.class)
public class RemoteStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<String> BALANCING_STRATEGY = AttributeDefinition.builder((Enum)Attribute.BALANCING_STRATEGY, (Object)RoundRobinBalancingStrategy.class.getName()).immutable().build();
    static final AttributeDefinition<Long> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECT_TIMEOUT, (Object)60000L).build();
    static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder((Enum)Attribute.FORCE_RETURN_VALUES, (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> HOTROD_WRAPPING = AttributeDefinition.builder((Enum)Attribute.HOTROD_WRAPPING, (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> RAW_VALUES = AttributeDefinition.builder((Enum)Attribute.RAW_VALUES, (Object)false).immutable().build();
    @Deprecated(forRemoval=true)
    static final AttributeDefinition<Integer> KEY_SIZE_ESTIMATE = AttributeDefinition.builder((Enum)Attribute.KEY_SIZE_ESTIMATE, (Object)64).immutable().build();
    @Deprecated(forRemoval=true)
    static final AttributeDefinition<Integer> VALUE_SIZE_ESTIMATE = AttributeDefinition.builder((Enum)Attribute.VALUE_SIZE_ESTIMATE, (Object)512).immutable().build();
    static final AttributeDefinition<String> MARSHALLER = AttributeDefinition.builder((Enum)Attribute.MARSHALLER, null, String.class).immutable().build();
    static final AttributeDefinition<ProtocolVersion> PROTOCOL_VERSION = AttributeDefinition.builder((Enum)Attribute.PROTOCOL_VERSION, (Object)ProtocolVersion.DEFAULT_PROTOCOL_VERSION).immutable().build();
    static final AttributeDefinition<String> REMOTE_CACHE_NAME = AttributeDefinition.builder((Enum)Attribute.REMOTE_CACHE_NAME, (Object)"").immutable().build();
    static final AttributeDefinition<String> URI = AttributeDefinition.builder((Enum)Attribute.URI, null, String.class).immutable().serializer((writer, name, value) -> writer.writeAttribute(name, HotRodURI.create((String)value).toString(writer.clearTextSecrets()))).build();
    static final AttributeDefinition<Long> SOCKET_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.SOCKET_TIMEOUT, (Object)60000L).build();
    static final AttributeDefinition<Boolean> TCP_NO_DELAY = AttributeDefinition.builder((Enum)Attribute.TCP_NO_DELAY, (Object)true).build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> balancingStrategy;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> connectionTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> forceReturnValues;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> hotRodWrapping;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> rawValues;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> keySizeEstimate;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> valueSizeEstimate;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> marshaller;
    private final org.infinispan.commons.configuration.attributes.Attribute<ProtocolVersion> protocolVersion;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> remoteCacheName;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> uri;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> socketTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> tcpNoDelay;
    private final ConnectionPoolConfiguration connectionPool;
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final SecurityConfiguration security;
    private List<RemoteServerConfiguration> servers;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RemoteStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{BALANCING_STRATEGY, CONNECTION_TIMEOUT, FORCE_RETURN_VALUES, HOTROD_WRAPPING, RAW_VALUES, KEY_SIZE_ESTIMATE, MARSHALLER, PROTOCOL_VERSION, REMOTE_CACHE_NAME, SOCKET_TIMEOUT, TCP_NO_DELAY, VALUE_SIZE_ESTIMATE, URI});
    }

    public RemoteStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, ExecutorFactoryConfiguration asyncExecutorFactory, ConnectionPoolConfiguration connectionPool, SecurityConfiguration security, List<RemoteServerConfiguration> servers) {
        super(attributes, async);
        this.balancingStrategy = attributes.attribute(BALANCING_STRATEGY);
        this.connectionTimeout = attributes.attribute(CONNECTION_TIMEOUT);
        this.forceReturnValues = attributes.attribute(FORCE_RETURN_VALUES);
        this.hotRodWrapping = attributes.attribute(HOTROD_WRAPPING);
        this.rawValues = attributes.attribute(RAW_VALUES);
        this.keySizeEstimate = attributes.attribute(KEY_SIZE_ESTIMATE);
        this.valueSizeEstimate = attributes.attribute(VALUE_SIZE_ESTIMATE);
        this.marshaller = attributes.attribute(MARSHALLER);
        this.protocolVersion = attributes.attribute(PROTOCOL_VERSION);
        this.remoteCacheName = attributes.attribute(REMOTE_CACHE_NAME);
        this.uri = attributes.attribute(URI);
        this.socketTimeout = attributes.attribute(SOCKET_TIMEOUT);
        this.tcpNoDelay = attributes.attribute(TCP_NO_DELAY);
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.connectionPool = connectionPool;
        this.security = security;
        this.servers = servers;
    }

    public String uri() {
        return (String)this.uri.get();
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public String balancingStrategy() {
        return (String)this.balancingStrategy.get();
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public long connectionTimeout() {
        return (Long)this.connectionTimeout.get();
    }

    public boolean forceReturnValues() {
        return (Boolean)this.forceReturnValues.get();
    }

    @Deprecated(forRemoval=true)
    public boolean hotRodWrapping() {
        return (Boolean)this.hotRodWrapping.get();
    }

    @Deprecated(forRemoval=true)
    public int keySizeEstimate() {
        return (Integer)this.keySizeEstimate.get();
    }

    public String marshaller() {
        return (String)this.marshaller.get();
    }

    public ProtocolVersion protocol() {
        return (ProtocolVersion)this.protocolVersion.get();
    }

    @Deprecated(forRemoval=true)
    public boolean rawValues() {
        return (Boolean)this.rawValues.get();
    }

    public String remoteCacheName() {
        return (String)this.remoteCacheName.get();
    }

    public List<RemoteServerConfiguration> servers() {
        return this.servers;
    }

    public long socketTimeout() {
        return (Long)this.socketTimeout.get();
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.tcpNoDelay.get();
    }

    @Deprecated(forRemoval=true)
    public String transportFactory() {
        return null;
    }

    @Deprecated(forRemoval=true)
    public int valueSizeEstimate() {
        return (Integer)this.valueSizeEstimate.get();
    }

    public SecurityConfiguration security() {
        return this.security;
    }
}

