/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.wildfly.microprofile.reactive.messaging.common.security.BaseReactiveMessagingSslConfigProcessor;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context.WildFlyKafkaSSLEngineFactory;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context._private.MicroProfileReactiveMessagingKafkaLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

class KafkaReactiveMessagingSslConfigProcessor
extends BaseReactiveMessagingSslConfigProcessor {
    static final String SSL_CONTEXT_PROPERTY_SUFFIX = "wildfly.elytron.ssl.context";
    private static final String SSL_ENGINE_FACTORY_CLASS = "ssl.engine.factory.class";
    private static final String CONNECTOR_NAME = "smallrye-kafka";
    private static final boolean DISABLE_SNAPPY_ON_WINDOWS_AND_MAC = false;
    private static final String OS_NAME = "os.name";
    public static final String COMPRESSION_TYPE_PROPERTY_SUFFIX = ".compression.type";
    public static final String SNAPPY_COMPRESSION = "snappy";
    private final boolean runningOnWindowsOrMac;

    KafkaReactiveMessagingSslConfigProcessor() {
        super(CONNECTOR_NAME);
        String os = WildFlySecurityManager.getPropertyPrivileged((String)OS_NAME, (String)"x").toLowerCase(Locale.ENGLISH);
        this.runningOnWindowsOrMac = os.startsWith("windows") || os.startsWith("mac os");
    }

    protected BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext createSecurityDeploymentContext() {
        return new KafkaSecurityDeploymentContext();
    }

    protected boolean isExtraConfigValueCheck() {
        return false;
    }

    protected void extraConfigValueCheck(String key, String value) throws DeploymentUnitProcessingException {
        if (key.endsWith(COMPRESSION_TYPE_PROPERTY_SUFFIX) && value.trim().equals(SNAPPY_COMPRESSION)) {
            throw MicroProfileReactiveMessagingKafkaLogger.LOGGER.snappyCompressionNotSupportedOnWindows(key);
        }
    }

    private class KafkaSecurityDeploymentContext
    implements BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext {
        private final Map<String, String> addedProperties = new HashMap<String, String>();

        private KafkaSecurityDeploymentContext() {
        }

        public void setGlobalSslContext(String globalPropertyPrefix, String sslContext) {
            this.setSslContext(globalPropertyPrefix, sslContext);
        }

        public void setConnectorSslContext(String connectorPrefix, String sslContext) {
            this.setSslContext(connectorPrefix, sslContext);
        }

        private void setSslContext(String prefix, String sslContext) {
            if (sslContext == null) {
                return;
            }
            this.addedProperties.put(prefix + KafkaReactiveMessagingSslConfigProcessor.SSL_ENGINE_FACTORY_CLASS, WildFlyKafkaSSLEngineFactory.class.getName());
        }

        public Map<String, String> complete(DeploymentPhaseContext phaseContext) {
            return this.addedProperties;
        }
    }
}

