/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpServerMetrics
implements OperationListener {
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named((String)"http-server-request-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpServerMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        String durationInstrumentName = HttpMetricsUtil.emitNewSemconvMetrics ? "http.server.request.duration" : "http.server.duration";
        this.duration = HttpMetricsUtil.createDurationHistogram(meter, durationInstrumentName, "The duration of the inbound HTTP request");
        this.requestSize = meter.histogramBuilder("http.server.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.server.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, TemporaryMetricsView.applyActiveRequestsView(startAttributes), context);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        State state = (State)context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, TemporaryMetricsView.applyActiveRequestsView(state.startAttributes()), context);
        Attributes durationAndSizeAttributes = TemporaryMetricsView.applyServerDurationAndSizeView(state.startAttributes(), endAttributes);
        this.duration.record(HttpMetricsUtil.nanosToUnit(endNanos - state.startTimeNanos()), durationAndSizeAttributes, context);
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, state.startAttributes());
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize.longValue(), durationAndSizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, state.startAttributes())) != null) {
            this.responseSize.record(responseBodySize.longValue(), durationAndSizeAttributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

