/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.metadata;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.ee.cache.offset.Value;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryComputeMutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.metadata.fine.CompositeImmutableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.MutableSessionAccessMetaDataOffsetValues;
import org.wildfly.clustering.web.cache.session.metadata.fine.MutableSessionAccessMetaDataValues;
import org.wildfly.clustering.web.cache.session.metadata.fine.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntryFunction;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntryFunction;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.web.hotrod.session.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.metadata.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<C>
implements SessionMetaDataFactory<SessionMetaDataEntry<C>> {
    private final RemoteCache<Key<String>, Object> cache;
    private final Flag[] ignoreReturnFlags;
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaDataEntry> accessMetaDataCache;

    public HotRodSessionMetaDataFactory(HotRodConfiguration configuration) {
        this.cache = configuration.getCache();
        this.ignoreReturnFlags = configuration.getIgnoreReturnFlags();
        this.creationMetaDataCache = configuration.getCache();
        this.accessMetaDataCache = configuration.getCache();
    }

    public SessionMetaDataEntry<C> createValue(String id, Duration defaultTimeout) {
        DefaultSessionCreationMetaDataEntry creationMetaData = new DefaultSessionCreationMetaDataEntry();
        creationMetaData.setTimeout(defaultTimeout);
        DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
        this.creationMetaDataCache.withFlags(this.ignoreReturnFlags).put((Object)new SessionCreationMetaDataKey(id), (Object)creationMetaData);
        new RemoteCacheEntryMutator(this.accessMetaDataCache, this.ignoreReturnFlags, (Object)new SessionAccessMetaDataKey(id), (Object)accessMetaData, () -> ((SessionCreationMetaDataEntry)creationMetaData).getTimeout()).mutate();
        return new DefaultSessionMetaDataEntry((SessionCreationMetaDataEntry)creationMetaData, (SessionAccessMetaDataEntry)accessMetaData);
    }

    public SessionMetaDataEntry<C> findValue(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        Map entries = this.cache.getAll(Set.of(creationMetaDataKey, accessMetaDataKey));
        SessionCreationMetaDataEntry creationMetaData = (SessionCreationMetaDataEntry)entries.get((Object)creationMetaDataKey);
        SessionAccessMetaDataEntry accessMetaData = (SessionAccessMetaDataEntry)entries.get((Object)accessMetaDataKey);
        return creationMetaData != null && accessMetaData != null ? new DefaultSessionMetaDataEntry(creationMetaData, accessMetaData) : null;
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        final OffsetValue timeoutOffset = OffsetValue.from((Duration)entry.getCreationMetaDataEntry().getTimeout());
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (Value)timeoutOffset);
        MutableSessionAccessMetaDataOffsetValues values = MutableSessionAccessMetaDataOffsetValues.from((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry(), (MutableSessionAccessMetaDataValues)values);
        RemoteCacheEntryComputeMutator creationMetaDataMutator = new RemoteCacheEntryComputeMutator(this.creationMetaDataCache, this.ignoreReturnFlags, (Object)new SessionCreationMetaDataKey(id), (BiFunction)new SessionCreationMetaDataEntryFunction(timeoutOffset));
        RemoteCacheEntryComputeMutator accessMetaDataMutator = new RemoteCacheEntryComputeMutator(this.accessMetaDataCache, this.ignoreReturnFlags, (Object)new SessionAccessMetaDataKey(id), (BiFunction)new SessionAccessMetaDataEntryFunction(values), () -> ((SessionCreationMetaData)creationMetaData).getTimeout());
        Mutator mutator = new Mutator(){
            final /* synthetic */ Mutator val$creationMetaDataMutator;
            final /* synthetic */ Mutator val$accessMetaDataMutator;
            {
                this.val$creationMetaDataMutator = mutator;
                this.val$accessMetaDataMutator = mutator2;
            }

            public void mutate() {
                if (!timeoutOffset.getOffset().isZero()) {
                    this.val$creationMetaDataMutator.mutate();
                }
                this.val$accessMetaDataMutator.mutate();
            }
        };
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData, mutator);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        return new CompositeImmutableSessionMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
    }

    public boolean remove(String id) {
        this.accessMetaDataCache.withFlags(this.ignoreReturnFlags).remove((Object)new SessionAccessMetaDataKey(id));
        this.creationMetaDataCache.withFlags(this.ignoreReturnFlags).remove((Object)new SessionCreationMetaDataKey(id));
        return true;
    }
}

