/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import io.micrometer.registry.otlp.OtlpStepTuple2;
import io.micrometer.registry.otlp.StepMax;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

class OtlpStepDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final OtlpStepTuple2<Long, Double> countTotal;
    private final StepMax max;

    OtlpStepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, long stepMillis) {
        super(id, scale, OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, AggregationTemporality.DELTA, stepMillis));
        this.countTotal = new OtlpStepTuple2<Long, Double>(clock, stepMillis, 0L, 0.0, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new StepMax(clock, stepMillis);
    }

    protected void recordNonNegative(double amount) {
        this.count.add(1L);
        this.total.add(amount);
        this.max.record(amount);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalAmount() {
        return (Double)this.countTotal.poll2();
    }

    public double max() {
        return (Double)this.max.poll();
    }

    void _closingRollover() {
        this.countTotal._closingRollover();
        this.max._closingRollover();
        if (this.histogram instanceof OtlpStepBucketHistogram) {
            ((OtlpStepBucketHistogram)this.histogram)._closingRollover();
        }
    }
}

