/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedConstructor;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedField;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedMethod;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotationIndex;
import org.wildfly.unstable.api.annotation.classpath.index.OverallIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ReusableStreams;

public class RuntimeIndex {
    public static final String BYTECODE_CONSTRUCTOR_NAME = "<init>";
    private static final byte[] OBJECT_BYTES = new byte[]{0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116};
    public static final ByteArrayKey JAVA_LANG_OBJECT_KEY = ByteArrayKey.create(OBJECT_BYTES, 0, OBJECT_BYTES.length);
    private static final ByteArrayOutputStream BYTE_ARRAY_OUTPUT_STREAM = new ByteArrayOutputStream(2048);
    public static final ByteArrayKey BYTECODE_CONSTRUCTOR_KEY;
    private final Map<ByteArrayKey, Set<String>> allClassesWithAnnotations;
    private final Map<String, Set<String>> annotationsWithAnnotations;
    private final Map<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>> methodsWithAnnotations;
    private final Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>> fieldsWithAnnotations;
    private final Map<ByteArrayKey, String> classNamesByKey;
    private final Map<String, ByteArrayKey> classKeysByName;
    private final Map<ByteArrayKey, String> methodNamesByKey;
    private final Map<ByteArrayKey, String> fieldNamesByKey;
    private final Map<ByteArrayKey, String> methodDescriptorsByKey;

    private RuntimeIndex(Map<ByteArrayKey, Set<String>> allClassesWithAnnotations, Map<String, Set<String>> annotationsWithAnnotations, Map<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>> methodsWithAnnotations, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>> fieldsWithAnnotations, Map<ByteArrayKey, String> classNamesByKey, Map<String, ByteArrayKey> classKeysByName, Map<ByteArrayKey, String> methodNamesByKey, Map<ByteArrayKey, String> fieldNamesByKey, Map<ByteArrayKey, String> methodDescriptorsByKey) {
        this.allClassesWithAnnotations = Collections.unmodifiableMap(allClassesWithAnnotations);
        this.annotationsWithAnnotations = Collections.unmodifiableMap(annotationsWithAnnotations);
        this.methodsWithAnnotations = Collections.unmodifiableMap(methodsWithAnnotations);
        this.fieldsWithAnnotations = Collections.unmodifiableMap(fieldsWithAnnotations);
        this.classNamesByKey = Collections.unmodifiableMap(classNamesByKey);
        this.classKeysByName = Collections.unmodifiableMap(classKeysByName);
        this.methodNamesByKey = Collections.unmodifiableMap(methodNamesByKey);
        this.fieldNamesByKey = Collections.unmodifiableMap(fieldNamesByKey);
        this.methodDescriptorsByKey = Collections.unmodifiableMap(methodDescriptorsByKey);
    }

    public static RuntimeIndex load(Path indexFile, Path ... additional) throws IOException {
        OverallIndex overallIndex = OverallIndex.load(indexFile, additional);
        return RuntimeIndex.convertOverallIndexToRuntimeIndex(overallIndex);
    }

    public static RuntimeIndex load(List<URL> urls) throws IOException {
        OverallIndex overallIndex = OverallIndex.load(urls);
        return RuntimeIndex.convertOverallIndexToRuntimeIndex(overallIndex);
    }

    private static RuntimeIndex convertOverallIndexToRuntimeIndex(OverallIndex overallIndex) {
        HashMap<ByteArrayKey, String> classNamesByKey = new HashMap<ByteArrayKey, String>();
        HashMap<String, ByteArrayKey> classKeysByName = new HashMap<String, ByteArrayKey>();
        HashMap<ByteArrayKey, String> methodNamesByKey = new HashMap<ByteArrayKey, String>();
        HashMap<ByteArrayKey, String> fieldNamesByKey = new HashMap<ByteArrayKey, String>();
        HashMap<ByteArrayKey, String> methodDescriptorsByKey = new HashMap<ByteArrayKey, String>();
        HashMap<ByteArrayKey, Set<String>> allClassesWithAnnotations = new HashMap<ByteArrayKey, Set<String>>();
        HashMap<String, Set<String>> annotationsWithAnnotations = new HashMap<String, Set<String>>();
        HashMap<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>> methodsWithAnnotations = new HashMap<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>>();
        HashMap<ByteArrayKey, Map<ByteArrayKey, Set<String>>> fieldsWithAnnotations = new HashMap<ByteArrayKey, Map<ByteArrayKey, Set<String>>>();
        for (String annotation : overallIndex.getAnnotations()) {
            AnnotationIndex annotationIndex = overallIndex.getAnnotationIndex(annotation);
            RuntimeIndex.addClassesWithAnnotations(annotation, annotationIndex, allClassesWithAnnotations, annotationsWithAnnotations, classNamesByKey, classKeysByName);
            RuntimeIndex.addMethodsWithAnnotations(annotation, annotationIndex, methodsWithAnnotations, methodNamesByKey, methodDescriptorsByKey, classNamesByKey, classKeysByName);
            RuntimeIndex.addConstructorsWithAnnotations(annotation, annotationIndex, methodsWithAnnotations, methodNamesByKey, methodDescriptorsByKey, classNamesByKey, classKeysByName);
            RuntimeIndex.addFieldsWithAnnotations(annotation, annotationIndex, fieldsWithAnnotations, fieldNamesByKey, classNamesByKey, classKeysByName);
        }
        return new RuntimeIndex(allClassesWithAnnotations, annotationsWithAnnotations, methodsWithAnnotations, fieldsWithAnnotations, classNamesByKey, classKeysByName, methodNamesByKey, fieldNamesByKey, methodDescriptorsByKey);
    }

    private static void addClassesWithAnnotations(String annotation, AnnotationIndex annotationIndex, Map<ByteArrayKey, Set<String>> classesWithAnnotations, Map<String, Set<String>> annotationsWithAnnotations, Map<ByteArrayKey, String> classNamesByKey, Map<String, ByteArrayKey> classKeysByName) {
        Set annotations;
        ByteArrayKey vmClass;
        for (String clazz : annotationIndex.getAnnotatedClasses()) {
            vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(clazz));
            annotations = classesWithAnnotations.computeIfAbsent(vmClass, k -> new HashSet());
            annotations.add(annotation);
            classNamesByKey.put(vmClass, clazz);
            classKeysByName.put(clazz, vmClass);
        }
        for (String clazz : annotationIndex.getAnnotatedInterfaces()) {
            vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(clazz));
            annotations = classesWithAnnotations.computeIfAbsent(vmClass, k -> new HashSet());
            annotations.add(annotation);
            classNamesByKey.put(vmClass, clazz);
            classKeysByName.put(clazz, vmClass);
        }
        for (String clazz : annotationIndex.getAnnotatedAnnotations()) {
            vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(clazz));
            Set classAnnotations = classesWithAnnotations.computeIfAbsent(vmClass, k -> new HashSet());
            classAnnotations.add(annotation);
            Set annAnnotations = annotationsWithAnnotations.computeIfAbsent(clazz, k -> new HashSet());
            annAnnotations.add(annotation);
        }
    }

    private static void addMethodsWithAnnotations(String annotation, AnnotationIndex annotationIndex, Map<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>> methodsWithAnnotations, Map<ByteArrayKey, String> methodNamesByKey, Map<ByteArrayKey, String> methodDescriptorsByKey, Map<ByteArrayKey, String> classNamesByKey, Map<String, ByteArrayKey> classKeysByName) {
        for (AnnotatedMethod annotatedMethod : annotationIndex.getAnnotatedMethods()) {
            ByteArrayKey vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(annotatedMethod.getClassName()));
            ByteArrayKey methodname = RuntimeIndex.convertStringToByteArrayKey(annotatedMethod.getMethodName());
            ByteArrayKey descriptor = RuntimeIndex.convertStringToByteArrayKey(annotatedMethod.getDescriptor());
            classNamesByKey.put(vmClass, annotatedMethod.getClassName());
            classKeysByName.put(annotatedMethod.getClassName(), vmClass);
            methodNamesByKey.put(methodname, annotatedMethod.getMethodName());
            methodDescriptorsByKey.put(descriptor, annotatedMethod.getDescriptor());
            Map methodsForClass = methodsWithAnnotations.computeIfAbsent(vmClass, k -> new HashMap());
            Map descriptorsForMethod = methodsForClass.computeIfAbsent(methodname, k -> new HashMap());
            Set annotationsForMethod = descriptorsForMethod.computeIfAbsent(descriptor, k -> new HashSet());
            annotationsForMethod.add(annotation);
        }
    }

    private static void addConstructorsWithAnnotations(String annotation, AnnotationIndex annotationIndex, Map<ByteArrayKey, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>>> methodsWithAnnotations, Map<ByteArrayKey, String> methodNamesByKey, Map<ByteArrayKey, String> methodDescriptorsByKey, Map<ByteArrayKey, String> classNamesByKey, Map<String, ByteArrayKey> classKeysByName) {
        methodNamesByKey.put(BYTECODE_CONSTRUCTOR_KEY, BYTECODE_CONSTRUCTOR_NAME);
        for (AnnotatedConstructor annotatedConstructor : annotationIndex.getAnnotatedConstructors()) {
            ByteArrayKey vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(annotatedConstructor.getClassName()));
            ByteArrayKey descriptor = RuntimeIndex.convertStringToByteArrayKey(annotatedConstructor.getDescriptor());
            classNamesByKey.put(vmClass, annotatedConstructor.getClassName());
            classKeysByName.put(annotatedConstructor.getClassName(), vmClass);
            methodDescriptorsByKey.put(descriptor, annotatedConstructor.getDescriptor());
            Map methodsForClass = methodsWithAnnotations.computeIfAbsent(vmClass, k -> new HashMap());
            Map descriptorsForMethod = methodsForClass.computeIfAbsent(BYTECODE_CONSTRUCTOR_KEY, k -> new HashMap());
            Set annotationsForMethod = descriptorsForMethod.computeIfAbsent(descriptor, k -> new HashSet());
            annotationsForMethod.add(annotation);
        }
    }

    private static void addFieldsWithAnnotations(String annotation, AnnotationIndex annotationIndex, Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>> fieldsWithAnnotations, Map<ByteArrayKey, String> fieldNamesByKey, Map<ByteArrayKey, String> classNamesByKey, Map<String, ByteArrayKey> classKeysByName) {
        for (AnnotatedField annotatedField : annotationIndex.getAnnotatedFields()) {
            ByteArrayKey vmClass = RuntimeIndex.convertStringToByteArrayKey(RuntimeIndex.convertClassNameToVmFormat(annotatedField.getClassName()));
            ByteArrayKey fieldName = RuntimeIndex.convertStringToByteArrayKey(annotatedField.getFieldName());
            classNamesByKey.put(vmClass, annotatedField.getClassName());
            classKeysByName.put(annotatedField.getClassName(), vmClass);
            fieldNamesByKey.put(fieldName, annotatedField.getFieldName());
            Map fieldsForClass = fieldsWithAnnotations.computeIfAbsent(vmClass, k -> new HashMap());
            Set annotationsForMethod = fieldsForClass.computeIfAbsent(fieldName, k -> new HashSet());
            annotationsForMethod.add(annotation);
        }
    }

    private static ByteArrayKey convertStringToByteArrayKey(String s) {
        BYTE_ARRAY_OUTPUT_STREAM.reset();
        try (DataOutputStream dout = new DataOutputStream(BYTE_ARRAY_OUTPUT_STREAM);){
            dout.writeUTF(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayKey(BYTE_ARRAY_OUTPUT_STREAM.toByteArray());
    }

    public static String convertClassNameToVmFormat(String s) {
        return s.replaceAll("\\.", "/");
    }

    public static String convertClassNameToDotFormat(String s) {
        return s.replaceAll("/", ".");
    }

    public Set<String> getAnnotationsForClass(ByteArrayKey key) {
        return this.allClassesWithAnnotations.get(key);
    }

    public Set<String> getAnnotationsForAnnotation(String annotation) {
        return this.annotationsWithAnnotations.get(annotation);
    }

    public Set<String> getAnnotatedAnnotations() {
        return this.annotationsWithAnnotations.keySet();
    }

    public Set<String> getAnnotationsForMethod(ByteArrayKey methodClass, Supplier<ByteArrayKey> methodName, Supplier<ByteArrayKey> methodDescriptor) {
        Map<ByteArrayKey, Map<ByteArrayKey, Set<String>>> methodsInClass = this.methodsWithAnnotations.get(methodClass);
        if (methodsInClass == null) {
            return null;
        }
        Map<ByteArrayKey, Set<String>> methodDescriptors = methodsInClass.get(methodName.get());
        if (methodDescriptors == null) {
            return null;
        }
        return methodDescriptors.get(methodDescriptor.get());
    }

    public Set<String> getAnnotationsForField(ByteArrayKey fieldClass, Supplier<ByteArrayKey> fieldName) {
        Map<ByteArrayKey, Set<String>> fieldsInClass = this.fieldsWithAnnotations.get(fieldClass);
        if (fieldsInClass == null) {
            return null;
        }
        return fieldsInClass.get(fieldName.get());
    }

    public String getClassNameFromKey(ByteArrayKey key) {
        return this.classNamesByKey.get(key);
    }

    public String getFieldNameFromKey(ByteArrayKey key) {
        return this.fieldNamesByKey.get(key);
    }

    public String getMethodNameFromKey(ByteArrayKey key) {
        return this.methodNamesByKey.get(key);
    }

    public String getMethodDescriptorsFromKey(ByteArrayKey key) {
        return this.methodDescriptorsByKey.get(key);
    }

    public Set<String> getAnnotationsForClass(String superClassName) {
        ByteArrayKey key = this.classKeysByName.get(superClassName);
        return this.getAnnotationsForClass(key);
    }

    static {
        try {
            BYTECODE_CONSTRUCTOR_KEY = RuntimeIndex.convertStringToByteArrayKey(BYTECODE_CONSTRUCTOR_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ByteArrayKey {
        private final byte[] arr;
        private final int start;
        private final int length;
        private volatile int hash = 0;

        private ByteArrayKey(byte[] arr) {
            this(arr, 0, arr.length);
        }

        private ByteArrayKey(byte[] arr, int start, int length) {
            if (arr == null) {
                throw new IllegalArgumentException("Null array");
            }
            this.arr = arr;
            this.start = start;
            this.length = length;
        }

        public static ByteArrayKey create(byte[] arr, int start, int length) {
            return new ByteArrayKey(arr, start, length);
        }

        public int hashCode() {
            int hashCode = this.hash;
            if (hashCode == 0 && this.arr.length > 0) {
                hashCode = 1;
                int end = this.start + this.length;
                for (int i = this.start; i < end; ++i) {
                    hashCode = 31 * hashCode + this.arr[i];
                }
                this.hash = hashCode;
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArrayKey that = (ByteArrayKey)o;
            if (this.length != that.length || this.hashCode() != that.hashCode()) {
                return false;
            }
            return Arrays.equals(this.arr, this.start, this.start + this.length, that.arr, that.start, that.start + that.length);
        }

        public String convertBytesToString(ReusableStreams reusableStreams) throws IOException {
            try (DataInputStream in = reusableStreams.getDataInputStream(this.arr, this.start, this.length);){
                String string = in.readUTF();
                return string;
            }
        }
    }
}

