/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.protostream;

import java.io.IOException;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ByteBufferMarshaller implements ProtoStreamMarshaller<ByteBufferImpl>
{
    INSTANCE;

    private static final int BUFFER_INDEX = 1;

    public ByteBufferImpl readFrom(ProtoStreamReader reader) throws IOException {
        ByteBufferImpl buffer = ByteBufferImpl.EMPTY_INSTANCE;
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    buffer = ByteBufferImpl.create((byte[])reader.readByteArray());
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return buffer;
    }

    public void writeTo(ProtoStreamWriter writer, ByteBufferImpl buffer) throws IOException {
        int length = buffer.getLength();
        if (length > 0) {
            writer.writeBytes(1, buffer.getBuf(), buffer.getOffset(), length);
        }
    }

    public Class<? extends ByteBufferImpl> getJavaClass() {
        return ByteBufferImpl.class;
    }
}

