/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.DeleteOp;
import org.jboss.as.patching.management.PatchStreamResourceOperationStepHandler;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.dmr.ModelNode;

public class LocalAgeoutHistoryHandler
extends PatchStreamResourceOperationStepHandler {
    public static final LocalAgeoutHistoryHandler INSTANCE = new LocalAgeoutHistoryHandler();
    static final FilenameFilter ALL = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };
    static final FilenameFilter HISTORY_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !"patch.xml".equals(name) && !"rollback.xml".equals(name);
        }
    };

    @Override
    protected void execute(OperationContext context, ModelNode operation, InstallationManager instMgr, String patchStream) throws OperationFailedException {
        try {
            if (patchStream != null) {
                InstalledIdentity installedIdentity = instMgr.getInstalledIdentity(patchStream, null);
                this.ageOutHistory(installedIdentity);
            } else {
                for (InstalledIdentity installedIdentity : instMgr.getInstalledIdentities()) {
                    this.ageOutHistory(installedIdentity);
                }
            }
        }
        catch (PatchingException e) {
            throw new IllegalStateException(PatchLogger.ROOT_LOGGER.failedToLoadIdentity(), e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void ageOutHistory(InstalledIdentity installedIdentity) {
        PatchableTarget.TargetInfo info;
        try {
            info = installedIdentity.getIdentity().loadTargetInfo();
        }
        catch (IOException e) {
            throw new IllegalStateException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(installedIdentity.getIdentity().getName()), e);
        }
        PatchingHistory.Iterator i = PatchingHistory.Factory.iterator(installedIdentity, info);
        if (i.hasNextCP()) {
            i.nextCP();
            while (i.hasNext()) {
                File patchHistoryDir;
                PatchingHistory.Entry entry = (PatchingHistory.Entry)i.next();
                Map<String, String> layerPatches = entry.getLayerPatches();
                ArrayList<DeleteOp> ops = new ArrayList<DeleteOp>();
                if (!layerPatches.isEmpty()) {
                    for (String layerName : layerPatches.keySet()) {
                        Layer layer = installedIdentity.getLayer(layerName);
                        if (layer == null) {
                            throw new IllegalStateException(PatchLogger.ROOT_LOGGER.layerNotFound(layerName));
                        }
                        File patchDir = layer.getDirectoryStructure().getModulePatchDirectory(layerPatches.get(layerName));
                        if (!patchDir.exists()) continue;
                        ops.add(new DeleteOp(patchDir, ALL));
                    }
                }
                if ((patchHistoryDir = installedIdentity.getInstalledImage().getPatchHistoryDir(entry.getPatchId())).exists()) {
                    ops.add(new DeleteOp(patchHistoryDir, HISTORY_FILTER));
                }
                try {
                    DeleteOp.execute(ops);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

