/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11.messaging;

import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.webservices11.wscoor.processors.ActivationCoordinatorProcessor;
import com.arjuna.wsc.InvalidCreateParametersException;
import com.arjuna.wsc11.ContextFactory;
import com.arjuna.wsc11.ContextFactoryMapper;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.soap.SOAPFaultException;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContext;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CreateCoordinationContextResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CreateCoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.Expires;

public class ActivationCoordinatorProcessorImpl
extends ActivationCoordinatorProcessor {
    @Override
    public CreateCoordinationContextResponseType createCoordinationContext(CreateCoordinationContextType createCoordinationContext, MAP map, boolean isSecure) {
        ContextFactoryMapper contextFactoryMapper = ContextFactoryMapper.getMapper();
        try {
            String coordinationType = createCoordinationContext.getCoordinationType();
            ContextFactory contextFactory = contextFactoryMapper.getContextFactory(coordinationType);
            if (contextFactory != null) {
                try {
                    Expires expiresElement = createCoordinationContext.getExpires();
                    Long expires = expiresElement == null ? null : Long.valueOf(expiresElement.getValue());
                    CoordinationContext coordinationContext = contextFactory.create(coordinationType, expires, createCoordinationContext.getCurrentContext(), isSecure);
                    CreateCoordinationContextResponseType response = new CreateCoordinationContextResponseType();
                    response.setCoordinationContext(coordinationContext);
                    return response;
                }
                catch (InvalidCreateParametersException invalidCreateParametersException) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev((Throwable)invalidCreateParametersException, "{0}, type {1} and context {2}", (Object)WSCLogger.i18NLogger.get_wsc11_messaging_ActivationCoordinatorProcessorImpl_1(), (Object)coordinationType, (Object)contextFactory);
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_ActivationCoordinatorProcessorImpl_1());
                    throw new SOAPFaultException(soapFault);
                }
                catch (Throwable th) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev(th, "Unexpected exception thrown from create coordination context: type {1} and context {2}", (Object)coordinationType, (Object)contextFactory);
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_CREATE_CONTEXT_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_CREATE_CONTEXT_QNAME).addTextNode(th.getMessage());
                    throw new SOAPFaultException(soapFault);
                }
            }
            if (WSCLogger.logger.isTraceEnabled()) {
                WSCLogger.logger.tracev("CreateCoordinationContext called for unknown coordination type: {0} [{1}]", (Object)coordinationType, (Object)WSCLogger.i18NLogger.get_wsc11_messaging_ActivationCoordinatorProcessorImpl_1());
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME);
            soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_ActivationCoordinatorProcessorImpl_1());
            throw new SOAPFaultException(soapFault);
        }
        catch (SOAPException se) {
            WSCLogger.i18NLogger.error_failure_to_create_coordination_context(createCoordinationContext == null ? null : createCoordinationContext.getCoordinationType(), se);
            throw new ProtocolException((Throwable)se);
        }
    }
}

