/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.coordinator.at;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.jbossts.xts.recovery.XTSRecoveryModule;
import org.jboss.jbossts.xts.recovery.coordinator.at.RecoverySubordinateATCoordinator;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;

public class SubordinateATCoordinatorRecoveryModule
implements XTSRecoveryModule {
    private String _transactionType = "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator/TwoPhase/SubordinateATCoordinator";
    private Vector _transactionUidVector = null;
    private static RecoveryStore _recoveryStore = null;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    public SubordinateATCoordinatorRecoveryModule() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"SubordinateATCoordinatorRecoveryModule created - default");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
    }

    @Override
    public void install() {
    }

    @Override
    public void uninstall() {
    }

    public void periodicWorkFirstPass() {
        boolean SubordinateCoordinators = false;
        InputObjectState acc_uids = new InputObjectState();
        try {
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)"StatusModule: first pass ");
            }
            SubordinateCoordinators = _recoveryStore.allObjUids(this._transactionType, acc_uids);
        }
        catch (ObjectStoreException ex) {
            RecoveryLogger.i18NLogger.warn_coordinator_at_SubordinateATCoordinatorRecoveryModule_1(ex);
        }
        if (SubordinateCoordinators) {
            this._transactionUidVector = this.processTransactions(acc_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"SubordinateATCoordinatorRecoveryModule: Second pass ");
        }
        if (this._transactionUidVector != null) {
            this.processTransactionsStatus();
        }
    }

    protected SubordinateATCoordinatorRecoveryModule(String type) {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("SubordinateATCoordinatorRecoveryModule created " + type));
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        this._transactionType = type;
    }

    private void doRecoverTransaction(Uid recoverUid) {
        boolean commitThisTransaction = true;
        if (SubordinateATCoordinator.getRecoveredCoordinator(recoverUid.stringForm()) != null) {
            return;
        }
        int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
        boolean inFlight = this.isTransactionInMidFlight(theStatus);
        String Status2 = ActionStatus.stringForm((int)theStatus);
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status2 + " in flight is " + inFlight));
        }
        if (!inFlight) {
            try {
                RecoveryLogger.logger.debug((Object)("jjh doing revovery here for " + String.valueOf(recoverUid)));
                RecoverySubordinateATCoordinator rcvSubordinateCoordinator = new RecoverySubordinateATCoordinator(recoverUid);
                rcvSubordinateCoordinator.replayPhase2();
            }
            catch (Exception ex) {
                RecoveryLogger.i18NLogger.warn_coordinator_at_SubordinateATCoordinatorRecoveryModule_2(recoverUid, ex);
            }
        }
    }

    private boolean isTransactionInMidFlight(int status) {
        boolean inFlight = false;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                inFlight = true;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                inFlight = false;
                break;
            }
            default: {
                inFlight = false;
            }
        }
        return inFlight;
    }

    private Vector processTransactions(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("processing " + this._transactionType + " transactions"));
        }
        Uid NULL_UID = Uid.nullUid();
        Uid theUid = null;
        while (true) {
            try {
                theUid = UidHelper.unpackFrom((InputBuffer)uids);
            }
            catch (Exception ex) {
                break;
            }
            if (theUid.equals(NULL_UID)) break;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("found transaction " + String.valueOf(theUid)));
            }
            uidVector.addElement(theUid);
        }
        return uidVector;
    }

    private void processTransactionsStatus() {
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_recoveryStore.currentState(currentUid, this._transactionType) == -1) continue;
                this.doRecoverTransaction(currentUid);
            }
            catch (ObjectStoreException ex) {
                RecoveryLogger.i18NLogger.warn_coordinator_at_SubordinateATCoordinatorRecoveryModule_3(currentUid, ex);
            }
        }
        XTSATRecoveryManager.getRecoveryManager().setSubordinateCoordinatorRecoveryStarted();
    }
}

