/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.i18n.LogMessages;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.BlockingAsyncOutputStream;

@Provider
@Priority(value=4000)
public class DigitalSigningInterceptor
implements AsyncWriterInterceptor,
ContainerResponseFilter,
ClientRequestFilter {
    protected List<DKIMSignature> getHeaders(MultivaluedMap<String, Object> headers) {
        List signatures = (List)headers.get((Object)"DKIM-Signature");
        if (signatures == null || signatures.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DKIMSignature> list = new ArrayList<DKIMSignature>();
        for (Object obj : signatures) {
            if (!(obj instanceof DKIMSignature)) continue;
            list.add((DKIMSignature)obj);
        }
        return list;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.hasEntity()) {
            return;
        }
        MultivaluedMap headers = requestContext.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        for (DKIMSignature dosetaSignature : list) {
            KeyRepository repository = (KeyRepository)requestContext.getProperty(KeyRepository.class.getName());
            try {
                this.sign(repository, (MultivaluedMap<String, Object>)headers, null, dosetaSignature);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (responseContext.getEntity() != null) {
            return;
        }
        MultivaluedMap headers = responseContext.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        for (DKIMSignature dosetaSignature : list) {
            try {
                this.sign(null, (MultivaluedMap<String, Object>)headers, null, dosetaSignature);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        MultivaluedMap headers = context.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        if (list.isEmpty()) {
            context.proceed();
            return;
        }
        OutputStream old = context.getOutputStream();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            context.setOutputStream((OutputStream)baos);
            context.proceed();
            byte[] body = baos.toByteArray();
            for (DKIMSignature dosetaSignature : list) {
                KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
                this.sign(repository, (MultivaluedMap<String, Object>)headers, body, dosetaSignature);
            }
            old.write(body);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToSign(), e);
        }
        finally {
            context.setOutputStream(old);
        }
    }

    public CompletionStage<Void> asyncAroundWriteTo(AsyncWriterInterceptorContext context) {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        MultivaluedMap headers = context.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        if (list.isEmpty()) {
            return context.asyncProceed();
        }
        AsyncOutputStream old = context.getAsyncOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        context.setAsyncOutputStream((AsyncOutputStream)new BlockingAsyncOutputStream((OutputStream)baos));
        return context.asyncProceed().thenCompose(v -> {
            byte[] body = baos.toByteArray();
            try {
                for (DKIMSignature dosetaSignature : list) {
                    KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
                    this.sign(repository, (MultivaluedMap<String, Object>)headers, body, dosetaSignature);
                }
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                CompletableFuture ret = new CompletableFuture();
                ret.completeExceptionally(e);
                return ret;
            }
            return old.asyncWrite(body);
        }).whenComplete((v, t) -> {
            context.setAsyncOutputStream(old);
            if (t != null) {
                throw new RuntimeException(Messages.MESSAGES.failedToSign(), (Throwable)t);
            }
        });
    }

    protected void sign(KeyRepository repository, MultivaluedMap<String, Object> headers, byte[] body, DKIMSignature dosetaSignature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        if (dosetaSignature.getBased64Signature() != null) {
            return;
        }
        PrivateKey privateKey = dosetaSignature.getPrivateKey();
        if (privateKey == null) {
            if (repository == null) {
                repository = (KeyRepository)ResteasyContext.getContextData(KeyRepository.class);
            }
            if (repository == null) {
                throw new InvalidKeyException(Messages.MESSAGES.unableToLocatePrivateKey());
            }
            privateKey = repository.findPrivateKey(dosetaSignature);
            if (privateKey == null) {
                throw new InvalidKeyException(Messages.MESSAGES.unableToFindKey());
            }
        }
        dosetaSignature.sign((Map)headers, body, privateKey);
    }
}

