/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.metrics;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.PublisherDecorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class MetricDecorator
implements PublisherDecorator {
    @Inject
    @ConfigProperty(name="smallrye.messaging.metrics.mp.enabled", defaultValue="true")
    boolean enabled;
    private MetricRegistry registry;

    @Inject
    private void setMetricRegistry(@RegistryType(type=MetricRegistry.Type.BASE) Instance<MetricRegistry> registryInstance) {
        if (registryInstance.isResolvable()) {
            this.registry = (MetricRegistry)registryInstance.get();
        }
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, String channelName, boolean isConnector) {
        if (this.enabled && this.registry != null) {
            return publisher.invoke(this.incrementCount(channelName));
        }
        return publisher;
    }

    private Consumer<Message<?>> incrementCount(String channelName) {
        Counter counter = this.registry.counter("mp.messaging.message.count", new Tag[]{new Tag("channel", channelName)});
        return m -> counter.inc();
    }
}

