/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.security.AccessController;
import org.jboss.weld.security.GetContextClassLoaderAction;
import org.jboss.weld.security.SetContextClassLoaderAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContextClassLoaderAction(classLoader));
        } else {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

