/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.BatchFailedException;
import org.hibernate.jdbc.BatchedTooManyRowsAffectedException;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.TooManyRowsAffectedException;

public class Expectations {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(Expectations.class);
    private static final @UnknownKeyFor @NonNull @Initialized SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper(false);
    public static final @UnknownKeyFor @NonNull @Initialized int USUAL_EXPECTED_COUNT = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int USUAL_PARAM_POSITION = 1;
    public static final @UnknownKeyFor @NonNull @Initialized Expectation NONE = new Expectation(){

        @Override
        public void verifyOutcome(int rowCount, PreparedStatement statement, int batchPosition, String statementSQL) {
        }

        @Override
        public int prepare(PreparedStatement statement) {
            return 0;
        }

        @Override
        public boolean canBeBatched() {
            return true;
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized Expectation BASIC = new BasicExpectation(1);
    public static final @UnknownKeyFor @NonNull @Initialized Expectation PARAM = new BasicParamExpectation(1, 1);

    public static @UnknownKeyFor @NonNull @Initialized Expectation appropriateExpectation(@UnknownKeyFor @NonNull @Initialized ExecuteUpdateResultCheckStyle style) {
        switch (style) {
            case NONE: {
                return NONE;
            }
            case COUNT: {
                return BASIC;
            }
            case PARAM: {
                return PARAM;
            }
        }
        throw new HibernateException("unknown check style : " + style);
    }

    private Expectations() {
    }

    public static class BasicParamExpectation
    extends BasicExpectation {
        private final @UnknownKeyFor @NonNull @Initialized int parameterPosition;

        protected BasicParamExpectation(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int parameterPosition) {
            super(expectedRowCount);
            this.parameterPosition = parameterPosition;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getNumberOfParametersUsed() {
            return 1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int prepare(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) throws @UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized HibernateException {
            this.toCallableStatement(statement).registerOutParameter(this.parameterPosition, 2);
            return 1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canBeBatched() {
            return false;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized int determineRowCount(@UnknownKeyFor @NonNull @Initialized int reportedRowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
            try {
                return this.toCallableStatement(statement).getInt(this.parameterPosition);
            }
            catch (SQLException sqle) {
                sqlExceptionHelper.logExceptions(sqle, "could not extract row counts from CallableStatement");
                throw new GenericJDBCException("could not extract row counts from CallableStatement", sqle);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized CallableStatement toCallableStatement(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
            if (!(statement instanceof CallableStatement)) {
                throw new HibernateException("BasicParamExpectation operates exclusively on CallableStatements : " + statement.getClass());
            }
            return (CallableStatement)statement;
        }
    }

    public static class BasicExpectation
    implements Expectation {
        private final @UnknownKeyFor @NonNull @Initialized int expectedRowCount;

        protected BasicExpectation(@UnknownKeyFor @NonNull @Initialized int expectedRowCount) {
            this.expectedRowCount = expectedRowCount;
            if (expectedRowCount < 0) {
                throw new IllegalArgumentException("Expected row count must be greater than zero");
            }
        }

        @Override
        public final void verifyOutcome(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String statementSQL) {
            rowCount = this.determineRowCount(rowCount, statement);
            if (batchPosition < 0) {
                this.checkNonBatched(rowCount, statementSQL);
            } else {
                this.checkBatched(rowCount, batchPosition, statementSQL);
            }
        }

        private void checkBatched(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String statementSQL) {
            if (rowCount == -2) {
                LOG.debugf("Success of batch update unknown: %s", batchPosition);
            } else {
                if (rowCount == -3) {
                    throw new BatchFailedException("Batch update failed: " + batchPosition);
                }
                if (this.expectedRowCount > rowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update [" + batchPosition + "]; actual row count: " + rowCount + "; expected: " + this.expectedRowCount + "; statement executed: " + statementSQL);
                }
                if (this.expectedRowCount < rowCount) {
                    String msg = "Batch update returned unexpected row count from update [" + batchPosition + "]; actual row count: " + rowCount + "; expected: " + this.expectedRowCount;
                    throw new BatchedTooManyRowsAffectedException(msg, this.expectedRowCount, rowCount, batchPosition);
                }
            }
        }

        private void checkNonBatched(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized String statementSQL) {
            if (this.expectedRowCount > rowCount) {
                throw new StaleStateException("Unexpected row count: " + rowCount + "; expected: " + this.expectedRowCount + "; statement executed: " + statementSQL);
            }
            if (this.expectedRowCount < rowCount) {
                String msg = "Unexpected row count: " + rowCount + "; expected: " + this.expectedRowCount;
                throw new TooManyRowsAffectedException(msg, this.expectedRowCount, rowCount);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int prepare(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) throws @UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized HibernateException {
            return 0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canBeBatched() {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized int determineRowCount(@UnknownKeyFor @NonNull @Initialized int reportedRowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
            return reportedRowCount;
        }
    }
}

