/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.openid.OpenIdConstant;
import jakarta.security.enterprise.authentication.mechanism.http.openid.OpenIdProviderMetadata;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.AnnotationELPProcessor;
import org.glassfish.soteria.mechanisms.openid.controller.ProviderMetadataController;
import org.glassfish.soteria.mechanisms.openid.domain.ClaimsConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.LogoutConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdProviderData;

@ApplicationScoped
public class ConfigurationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private ProviderMetadataController providerMetadataController;
    private static final String SPACE_SEPARATOR = " ";
    private volatile transient LastBuiltConfig lastBuiltConfig;

    @Produces
    @RequestScoped
    public OpenIdConfiguration produceConfiguration(OpenIdAuthenticationMechanismDefinition definition) {
        OpenIdConfiguration cached;
        if (this.lastBuiltConfig == null) {
            this.lastBuiltConfig = new LastBuiltConfig(null, null);
        }
        if ((cached = this.lastBuiltConfig.cachedConfiguration(definition)) != null) {
            return cached;
        }
        OpenIdConfiguration config = this.buildConfig(definition);
        this.lastBuiltConfig = new LastBuiltConfig(definition, config);
        return config;
    }

    public OpenIdConfiguration buildConfig(OpenIdAuthenticationMechanismDefinition definition) {
        URL jwksURL;
        String providerURI = AnnotationELPProcessor.evalImmediate((String)definition.providerURI());
        OpenIdProviderMetadata providerMetadata = definition.providerMetadata();
        JsonObject providerDocument = this.providerMetadataController.getDocument(providerURI);
        String authorizationEndpoint = Utils.isEmpty((String)providerMetadata.authorizationEndpoint()) && providerDocument.containsKey((Object)"authorization_endpoint") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("authorization_endpoint")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.authorizationEndpoint());
        String tokenEndpoint = Utils.isEmpty((String)providerMetadata.tokenEndpoint()) && providerDocument.containsKey((Object)"token_endpoint") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("token_endpoint")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.tokenEndpoint());
        String userinfoEndpoint = Utils.isEmpty((String)providerMetadata.userinfoEndpoint()) && providerDocument.containsKey((Object)"userinfo_endpoint") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("userinfo_endpoint")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.userinfoEndpoint());
        String endSessionEndpoint = Utils.isEmpty((String)providerMetadata.endSessionEndpoint()) && providerDocument.containsKey((Object)"end_session_endpoint") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("end_session_endpoint")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.endSessionEndpoint());
        String jwksURI = Utils.isEmpty((String)providerMetadata.jwksURI()) && providerDocument.containsKey((Object)"jwks_uri") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("jwks_uri")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.jwksURI());
        try {
            jwksURL = new URL(jwksURI);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("jwksURI is invalid", ex);
        }
        String issuer = Utils.isEmpty((String)providerMetadata.issuer()) && providerDocument.containsKey((Object)"issuer") ? AnnotationELPProcessor.evalImmediate((String)providerDocument.getString("issuer")) : AnnotationELPProcessor.evalImmediate((String)providerMetadata.issuer());
        List supportedResponseTypes = null;
        if (providerDocument.containsKey((Object)"response_types_supported")) {
            supportedResponseTypes = providerDocument.getJsonArray("response_types_supported").getValuesAs(JsonString::getString);
        }
        if (Utils.isEmpty(supportedResponseTypes)) {
            String value = AnnotationELPProcessor.evalImmediate((String)providerMetadata.responseTypeSupported());
            supportedResponseTypes = Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
        }
        List supportedIdTokenSigningAlgorithms = null;
        if (providerDocument.containsKey((Object)"id_token_signing_alg_values_supported")) {
            supportedIdTokenSigningAlgorithms = providerDocument.getJsonArray("id_token_signing_alg_values_supported").getValuesAs(JsonString::getString);
        }
        if (Utils.isEmpty(supportedIdTokenSigningAlgorithms)) {
            String value = AnnotationELPProcessor.evalImmediate((String)providerMetadata.idTokenSigningAlgorithmsSupported());
            supportedIdTokenSigningAlgorithms = Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
        }
        List supportedSubjectTypes = null;
        if (providerDocument.containsKey((Object)"subject_types_supported")) {
            supportedSubjectTypes = providerDocument.getJsonArray("subject_types_supported").getValuesAs(JsonString::getString);
        }
        if (Utils.isEmpty(supportedSubjectTypes)) {
            String value = AnnotationELPProcessor.evalImmediate((String)providerMetadata.subjectTypeSupported());
            supportedSubjectTypes = Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
        }
        String clientId = AnnotationELPProcessor.evalImmediate((String)definition.clientId());
        char[] clientSecret = AnnotationELPProcessor.evalImmediate((String)definition.clientSecret()).toCharArray();
        String redirectURI = AnnotationELPProcessor.evalImmediate((String)definition.redirectURI());
        Object scopes = String.join((CharSequence)SPACE_SEPARATOR, definition.scope());
        scopes = (String)AnnotationELPProcessor.evalImmediate((String)definition.scopeExpression(), (Object)scopes);
        if (Utils.isEmpty((String)scopes)) {
            scopes = "openid";
        } else if (!((String)scopes).contains("openid")) {
            scopes = "openid " + (String)scopes;
        }
        String responseType = AnnotationELPProcessor.evalImmediate((String)definition.responseType());
        responseType = Arrays.stream(responseType.trim().split(SPACE_SEPARATOR)).map(String::toLowerCase).sorted().collect(Collectors.joining(SPACE_SEPARATOR));
        String responseMode = AnnotationELPProcessor.evalImmediate((String)definition.responseMode());
        String display = definition.display().toString().toLowerCase();
        display = AnnotationELPProcessor.evalImmediate((String)display);
        String prompt = Arrays.stream(definition.prompt()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(SPACE_SEPARATOR));
        prompt = (String)AnnotationELPProcessor.evalImmediate((String)definition.promptExpression(), (Object)prompt);
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        for (String extraParameter : definition.extraParameters()) {
            String[] parts = extraParameter.split("=");
            String key = parts[0];
            String value = parts[1];
            extraParameters.put(key, value);
        }
        boolean nonce = AnnotationELPProcessor.evalImmediate((String)definition.useNonceExpression(), (boolean)definition.useNonce());
        boolean session = AnnotationELPProcessor.evalImmediate((String)definition.useSessionExpression(), (boolean)definition.useSession());
        boolean redirectToOriginalResource = AnnotationELPProcessor.evalImmediate((String)definition.redirectToOriginalResourceExpression(), (boolean)definition.redirectToOriginalResource());
        int jwksConnectTimeout = AnnotationELPProcessor.evalImmediate((String)definition.jwksConnectTimeoutExpression(), (int)definition.jwksConnectTimeout());
        int jwksReadTimeout = AnnotationELPProcessor.evalImmediate((String)definition.jwksReadTimeoutExpression(), (int)definition.jwksReadTimeout());
        String callerNameClaim = AnnotationELPProcessor.evalImmediate((String)definition.claimsDefinition().callerNameClaim());
        String callerGroupsClaim = AnnotationELPProcessor.evalImmediate((String)definition.claimsDefinition().callerGroupsClaim());
        boolean notifyProvider = AnnotationELPProcessor.evalImmediate((String)definition.logout().notifyProviderExpression(), (boolean)definition.logout().notifyProvider());
        String logoutRedirectURI = AnnotationELPProcessor.evalImmediate((String)definition.logout().redirectURI());
        boolean accessTokenExpiry = AnnotationELPProcessor.evalImmediate((String)definition.logout().accessTokenExpiryExpression(), (boolean)definition.logout().accessTokenExpiry());
        boolean identityTokenExpiry = AnnotationELPProcessor.evalImmediate((String)definition.logout().identityTokenExpiryExpression(), (boolean)definition.logout().identityTokenExpiry());
        boolean tokenAutoRefresh = AnnotationELPProcessor.evalImmediate((String)definition.tokenAutoRefreshExpression(), (boolean)definition.tokenAutoRefresh());
        int tokenMinValidity = AnnotationELPProcessor.evalImmediate((String)definition.tokenMinValidityExpression(), (int)definition.tokenMinValidity());
        OpenIdConfiguration configuration = new OpenIdConfiguration().setProviderMetadata(new OpenIdProviderData(providerDocument).setAuthorizationEndpoint(authorizationEndpoint).setTokenEndpoint(tokenEndpoint).setUserinfoEndpoint(userinfoEndpoint).setEndSessionEndpoint(endSessionEndpoint).setJwksURL(jwksURL).setIssuer(issuer).setResponseTypeSupported(new HashSet(supportedResponseTypes)).setIdTokenSigningAlgorithmsSupported(new HashSet(supportedIdTokenSigningAlgorithms)).setSubjectTypesSupported(new HashSet(supportedSubjectTypes))).setClaimsConfiguration(new ClaimsConfiguration().setCallerNameClaim(callerNameClaim).setCallerGroupsClaim(callerGroupsClaim)).setLogoutConfiguration(new LogoutConfiguration().setNotifyProvider(notifyProvider).setRedirectURI(logoutRedirectURI).setAccessTokenExpiry(accessTokenExpiry).setIdentityTokenExpiry(identityTokenExpiry)).setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI).setRedirectToOriginalResource(redirectToOriginalResource).setScopes((String)scopes).setResponseType(responseType).setResponseMode(responseMode).setExtraParameters(extraParameters).setPrompt(prompt).setDisplay(display).setUseNonce(nonce).setUseSession(session).setJwksConnectTimeout(jwksConnectTimeout).setJwksReadTimeout(jwksReadTimeout).setTokenAutoRefresh(tokenAutoRefresh).setTokenMinValidity(tokenMinValidity);
        this.validateConfiguration(configuration);
        return configuration;
    }

    private void validateConfiguration(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(this.validateProviderMetadata(configuration));
        errorMessages.addAll(this.validateClientConfiguration(configuration));
        if (!errorMessages.isEmpty()) {
            throw new IllegalStateException(((Object)errorMessages).toString());
        }
    }

    private List<String> validateProviderMetadata(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (Utils.isEmpty((String)configuration.getProviderMetadata().getIssuerURI())) {
            errorMessages.add("issuer metadata is mandatory");
        }
        if (Utils.isEmpty((String)configuration.getProviderMetadata().getAuthorizationEndpoint())) {
            errorMessages.add("authorization_endpoint metadata is mandatory");
        }
        if (Utils.isEmpty((String)configuration.getProviderMetadata().getTokenEndpoint())) {
            errorMessages.add("token_endpoint metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getJwksURL() == null) {
            errorMessages.add("jwks_uri metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getResponseTypeSupported().isEmpty()) {
            errorMessages.add("response_types_supported metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getSubjectTypesSupported().isEmpty()) {
            errorMessages.add("subject_types_supported metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getIdTokenSigningAlgorithmsSupported().isEmpty()) {
            errorMessages.add("id_token_signing_alg_values_supported metadata is mandatory");
        }
        return errorMessages;
    }

    private List<String> validateClientConfiguration(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (Utils.isEmpty((String)configuration.getClientId())) {
            errorMessages.add("client_id request parameter is mandatory");
        }
        if (Utils.isEmpty((String)configuration.getRedirectURI())) {
            errorMessages.add("redirect_uri request parameter is mandatory");
        }
        if (configuration.getJwksConnectTimeout() <= 0) {
            errorMessages.add("jwksConnectTimeout value is not valid");
        }
        if (configuration.getJwksReadTimeout() <= 0) {
            errorMessages.add("jwksReadTimeout value is not valid");
        }
        if (Utils.isEmpty((String)configuration.getResponseType())) {
            errorMessages.add("The response type must contain at least one value");
        } else if (!(configuration.getProviderMetadata().getResponseTypeSupported().contains(configuration.getResponseType()) || OpenIdConstant.AUTHORIZATION_CODE_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.IMPLICIT_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.HYBRID_FLOW_TYPES.contains(configuration.getResponseType()))) {
            errorMessages.add("Unsupported OpenID Connect response type value : " + configuration.getResponseType());
        }
        Set supportedScopes = configuration.getProviderMetadata().getScopesSupported();
        if (!supportedScopes.isEmpty()) {
            for (String scope : configuration.getScopes().split(SPACE_SEPARATOR)) {
                if (supportedScopes.contains(scope)) continue;
                errorMessages.add(String.format("%s scope is not supported by %s OpenId Connect provider", scope, configuration.getProviderMetadata().getIssuerURI()));
            }
        }
        return errorMessages;
    }

    static class LastBuiltConfig {
        private final OpenIdAuthenticationMechanismDefinition definition;
        private final OpenIdConfiguration configuration;

        public LastBuiltConfig(OpenIdAuthenticationMechanismDefinition definition, OpenIdConfiguration configuration) {
            this.definition = definition;
            this.configuration = configuration;
        }

        OpenIdConfiguration cachedConfiguration(OpenIdAuthenticationMechanismDefinition definition) {
            if (this.definition != null && this.definition.equals(definition)) {
                return this.configuration;
            }
            return null;
        }
    }
}

