/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aesh.readline.PagingSupport;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.alias.AliasCompletion;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.History;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.TerminalBuilder;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.readline.util.FileAccessPermission;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;
import org.jboss.as.cli.CommandHistory;
import org.jboss.logging.Logger;

public class ReadlineConsole {
    private static final Logger LOG = Logger.getLogger((String)ReadlineConsole.class.getName());
    private static final boolean isTraceEnabled = LOG.isTraceEnabled();
    private final List<Completion> completions = new ArrayList<Completion>();
    private Readline readline;
    private CLITerminalConnection connection;
    private final CommandHistory history = new HistoryImpl();
    private final FileHistory readlineHistory;
    private Prompt prompt;
    private final Settings settings;
    private volatile boolean started;
    private volatile boolean closed;
    private Thread startThread;
    private Thread readingThread;
    private Consumer<String> callback;
    private final ExecutorService executor = Executors.newFixedThreadPool(1, r -> new Thread(r, "CLI command"));
    private final AliasManager aliasManager;
    private final List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final EnumMap<ReadlineFlag, Integer> READLINE_FLAGS = new EnumMap(ReadlineFlag.class);
    private Consumer<Signal> interruptHandler;
    private boolean isSystemTerminal;
    private boolean forcePaging;
    private PagingSupport pagingSupport;

    ReadlineConsole(Settings settings) throws IOException {
        this.settings = settings;
        this.readlineHistory = new FileHistory(settings.getHistoryFile(), settings.getHistorySize(), settings.getPermission(), false);
        if (settings.isDisableHistory()) {
            this.readlineHistory.disable();
        } else {
            this.readlineHistory.enable();
        }
        if (isTraceEnabled) {
            LOG.tracef("History is enabled? %s", (Object)(!settings.isDisableHistory() ? 1 : 0));
        }
        this.aliasManager = new AliasManager(new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases"), true);
        AliasPreProcessor aliasPreProcessor = new AliasPreProcessor(this.aliasManager);
        this.preProcessors.add((Function<String, Optional<String>>)aliasPreProcessor);
        this.completions.add((Completion)new AliasCompletion(this.aliasManager));
        this.readline = new Readline();
    }

    private void initializeConnection() throws IOException {
        if (this.connection == null) {
            this.connection = this.newConnection();
            this.pagingSupport = new PagingSupport((Connection)this.connection, this.readline, true);
            this.interruptHandler = signal -> {
                if (signal == Signal.INT) {
                    LOG.trace((Object)"Calling InterruptHandler");
                    this.connection.write(Config.getLineSeparator());
                    this.stop();
                }
            };
            this.connection.setSignalHandler(this.interruptHandler);
            Attributes attr = this.connection.getAttributes();
            attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
            this.connection.setAttributes(attr);
            this.connection.enterRawMode();
        }
    }

    public void setActionCallback(Consumer<String> callback) {
        this.callback = callback;
    }

    private CLITerminalConnection newConnection() throws IOException {
        LOG.trace((Object)"Creating terminal connection");
        Terminal terminal = TerminalBuilder.builder().input(this.settings.getInStream() == null ? System.in : this.settings.getInStream()).output(this.settings.getOutStream()).nativeSignals(true).name("CLI Terminal").system(!this.settings.isOutputRedefined()).build();
        if (isTraceEnabled) {
            LOG.tracef("New Terminal %s", terminal.getClass());
        }
        CLITerminalConnection c = new CLITerminalConnection(terminal, this);
        this.isSystemTerminal = c.supportsAnsi();
        return c;
    }

    public void setCompletionHandler(CompletionHandler<? extends CompleteOperation> ch) {
        this.readline = new Readline(EditModeBuilder.builder().create(), null, ch);
    }

    private Readline getReadLine() {
        if (this.readline == null) {
            this.readline = new Readline();
        }
        return this.readline;
    }

    public void addCompleter(Completion<? extends CompleteOperation> completer) {
        this.completions.add(completer);
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    public void clearScreen() {
        if (this.connection != null) {
            this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
        }
    }

    public String formatColumns(Collection<String> list) {
        String[] newList = new String[list.size()];
        list.toArray(newList);
        return Parser.formatDisplayList((String[])newList, (int)this.getHeight(), (int)this.getWidth());
    }

    public void print(String line, boolean collect) {
        LOG.tracef("Print %s", (Object)line);
        if (collect && this.isPagingOutputEnabled() && this.pagingSupport != null) {
            this.pagingSupport.addContent(line);
        } else if (this.connection == null) {
            PrintStream out = this.settings.getOutStream() == null ? System.out : this.settings.getOutStream();
            try {
                ((OutputStream)out).write(line.getBytes());
            }
            catch (IOException ex) {
                LOG.tracef("Print exception %s", (Object)ex);
            }
        } else {
            this.connection.write(line);
        }
    }

    public Key readKey() throws InterruptedException, IOException {
        return Key.findStartKey((int[])this.read());
    }

    private void printCollectedOutput() {
        if (!this.isPagingOutputEnabled()) {
            return;
        }
        this.pagingSupport.printCollectedOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] read() throws InterruptedException, IOException {
        this.initializeConnection();
        ActionDecoder decoder = new ActionDecoder();
        int[][] key = new int[][]{null};
        this.readingThread = Thread.currentThread();
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(signal -> {
            switch (signal) {
                case INT: {
                    LOG.tracef("Interrupting reading thread.", new Object[0]);
                    this.readingThread.interrupt();
                }
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.connection.enterRawMode();
        this.connection.setStdinHandler(keys -> {
            decoder.add(keys);
            if (decoder.hasNext()) {
                key[0] = decoder.next().buffer().array();
                this.connection.setStdinHandler(null);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
            this.connection.setAttributes(attributes);
            this.readingThread = null;
        }
        return key[0];
    }

    public void printNewLine(boolean collect) {
        this.print(Config.getLineSeparator(), collect);
    }

    public String readLine(String prompt) throws IOException, InterruptedException {
        return this.readLine(prompt, (Character)null);
    }

    public String readLine(String prompt, Character mask) throws InterruptedException, IOException {
        this.logPromptMask(prompt, mask);
        return this.readLine(new Prompt(prompt, mask));
    }

    public String readLine(Prompt prompt) throws InterruptedException, IOException {
        return this.readLine(prompt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        if (this.closed) {
            LOG.tracef("Console already closed, ignoring readLine", new Object[0]);
            return null;
        }
        if (this.started) {
            this.printCollectedOutput();
            this.pagingSupport.reset();
        }
        this.readingThread = Thread.currentThread();
        try {
            if (!this.started) {
                String string = this.promptFromNonStartedConsole(prompt, completer);
                return string;
            }
            String string = this.promptFromStartedConsole(prompt, completer, null);
            return string;
        }
        finally {
            this.readingThread = null;
        }
    }

    private String promptFromNonStartedConsole(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        this.initializeConnection();
        LOG.trace((Object)"Not started");
        String[] out = new String[1];
        if (this.connection.suspended()) {
            this.connection.awake();
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        this.getReadLine().readline((Connection)this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            this.connection.stopReading();
        }, lst, null, null, null, READLINE_FLAGS);
        this.connection.openBlockingInterruptable();
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptFromStartedConsole(Prompt prompt, Completion completer, History history) throws InterruptedException, IOException {
        this.initializeConnection();
        String[] out = new String[1];
        if (this.readingThread == this.startThread) {
            throw new RuntimeException("Can't prompt from the Thread that is reading terminal input");
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        this.readline.readline((Connection)this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            latch.countDown();
        }, lst, null, history, null, READLINE_FLAGS);
        try {
            latch.await();
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
        }
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    private void logPromptMask(String prompt, Character mask) {
        LOG.tracef("Prompt %s mask %s", (Object)prompt, (Object)mask);
    }

    public int getTerminalWidth() {
        return this.getWidth();
    }

    public int getTerminalHeight() {
        return this.getHeight();
    }

    private int getHeight() {
        if (this.connection == null) {
            return 40;
        }
        return this.connection.size().getHeight();
    }

    private int getWidth() {
        if (this.connection == null) {
            return 80;
        }
        return this.connection.size().getWidth();
    }

    public void start() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Console has already been closed");
        }
        if (!this.started) {
            this.initializeConnection();
            this.startThread = Thread.currentThread();
            this.started = true;
            this.loop();
            LOG.tracef("Started in thread %s. Waiting...", (Object)this.startThread.getName());
            try {
                this.connection.openBlockingInterruptable();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.trace((Object)"Leaving console");
        } else {
            LOG.trace((Object)"Already started");
        }
    }

    private void loop() {
        try {
            if (isTraceEnabled) {
                LOG.tracef("Set a readline callback with prompt %s", (Object)this.prompt);
            }
            if (!this.closed) {
                this.getReadLine().readline((Connection)this.connection, this.prompt, line -> {
                    LOG.tracef("Executing command %s in a new thread.", line);
                    if (line == null || line.trim().length() == 0 || this.handleAlias((String)line)) {
                        this.loop();
                        return;
                    }
                    this.executor.submit(() -> {
                        Consumer handler = this.connection.getSignalHandler();
                        Thread callingThread = Thread.currentThread();
                        this.connection.setSignalHandler(signal -> {
                            switch (signal) {
                                case INT: {
                                    LOG.tracef("Interrupting command: %s", line);
                                    callingThread.interrupt();
                                }
                            }
                        });
                        try {
                            this.pagingSupport.reset();
                            this.callback.accept((String)line);
                        }
                        catch (Throwable thr) {
                            this.connection.write("Unexpected exception");
                            thr.printStackTrace();
                        }
                        finally {
                            try {
                                this.printCollectedOutput();
                            }
                            finally {
                                Thread.interrupted();
                                this.connection.setSignalHandler(handler);
                                LOG.tracef("Done Executing command %s", line);
                                this.loop();
                            }
                        }
                    });
                }, this.completions, this.preProcessors, (History)this.readlineHistory, null, READLINE_FLAGS);
            }
        }
        catch (Exception ex) {
            this.connection.write("Unexpected exception");
            ex.printStackTrace();
        }
    }

    private boolean handleAlias(String line) {
        if (line.startsWith("alias ") || line.equals("alias")) {
            String out = this.aliasManager.parseAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        if (line.startsWith("unalias ") || line.equals("unalias")) {
            String out = this.aliasManager.removeAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        if (!this.closed) {
            LOG.trace((Object)"Stopping.");
            this.closed = true;
            if (this.readingThread != null) {
                LOG.trace((Object)"Interrupting reading thread");
                this.readingThread.interrupt();
            }
            if (this.started) {
                this.readlineHistory.stop();
                this.aliasManager.persist();
            }
            this.executor.shutdown();
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public boolean running() {
        return this.started;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt.contains("\u001b[") ? new Prompt(Parser.stripAwayAnsiCodes((String)prompt), prompt) : new Prompt(prompt);
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public boolean isPagingOutputEnabled() {
        if (this.forcePaging && this.settings.isOutputPaging()) {
            return true;
        }
        return this.settings.isOutputPaging() && this.isSystemTerminal;
    }

    public boolean isPagingOutputActive() {
        return this.pagingSupport != null && this.pagingSupport.isPagingOutputActive();
    }

    public void forcePagingOutput(boolean forcePaging) {
        this.forcePaging = forcePaging;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String handleBuiltins(String line) {
        if (this.handleAlias(line)) {
            return null;
        }
        return this.parse(line);
    }

    private String parse(String line) {
        Optional out = this.aliasManager.getAliasName(line);
        if (out.isPresent()) {
            line = (String)out.get();
        }
        return line;
    }

    static {
        READLINE_FLAGS.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
    }

    class HistoryImpl
    implements CommandHistory {
        HistoryImpl() {
        }

        @Override
        public List<String> asList() {
            ArrayList<String> lst = new ArrayList<String>();
            for (int[] l : ReadlineConsole.this.readlineHistory.getAll()) {
                lst.add(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])l)));
            }
            return lst;
        }

        @Override
        public boolean isUseHistory() {
            return ReadlineConsole.this.readlineHistory.isEnabled();
        }

        @Override
        public void setUseHistory(boolean useHistory) {
            if (useHistory) {
                ReadlineConsole.this.readlineHistory.enable();
            } else {
                ReadlineConsole.this.readlineHistory.disable();
            }
        }

        @Override
        public void clear() {
            ReadlineConsole.this.readlineHistory.clear();
        }

        @Override
        public int getMaxSize() {
            return ReadlineConsole.this.readlineHistory.size();
        }
    }

    public static class SettingsBuilder {
        private InputStream inStream;
        private OutputStream outStream;
        private boolean disableHistory;
        private File historyFile;
        private int historySize;
        private FileAccessPermission permission;
        private Runnable interrupt;
        private boolean outputRedefined;
        private boolean outputPaging;

        public SettingsBuilder inputStream(InputStream inStream) {
            this.inStream = inStream;
            return this;
        }

        public SettingsBuilder outputStream(OutputStream outStream) {
            this.outStream = outStream;
            return this;
        }

        public SettingsBuilder disableHistory(boolean disableHistory) {
            this.disableHistory = disableHistory;
            return this;
        }

        public SettingsBuilder historyFile(File historyFile) {
            this.historyFile = historyFile;
            return this;
        }

        public SettingsBuilder historySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public SettingsBuilder historyFilePermission(FileAccessPermission permission) {
            this.permission = permission;
            return this;
        }

        public SettingsBuilder interruptHook(Runnable interrupt) {
            this.interrupt = interrupt;
            return this;
        }

        public SettingsBuilder outputRedefined(boolean outputRedefined) {
            this.outputRedefined = outputRedefined;
            return this;
        }

        public SettingsBuilder outputPaging(boolean outputPaging) {
            this.outputPaging = outputPaging;
            return this;
        }

        public Settings create() {
            return new SettingsImpl(this.inStream, this.outStream, this.outputRedefined, this.disableHistory, this.historyFile, this.historySize, this.permission, this.interrupt, this.outputPaging);
        }
    }

    private static class SettingsImpl
    implements Settings {
        private final InputStream inStream;
        private final OutputStream outStream;
        private final boolean disableHistory;
        private final File historyFile;
        private final int historySize;
        private final FileAccessPermission permission;
        private final Runnable interrupt;
        private final boolean outputRedefined;
        private final boolean outputPaging;

        private SettingsImpl(InputStream inStream, OutputStream outStream, boolean outputRedefined, boolean disableHistory, File historyFile, int historySize, FileAccessPermission permission, Runnable interrupt, boolean outputPaging) {
            this.inStream = inStream;
            this.outStream = outStream;
            this.outputRedefined = outputRedefined;
            this.disableHistory = disableHistory;
            this.historyFile = historyFile;
            this.historySize = historySize;
            this.permission = permission;
            this.interrupt = interrupt;
            this.outputPaging = outputPaging;
        }

        @Override
        public InputStream getInStream() {
            return this.inStream;
        }

        @Override
        public OutputStream getOutStream() {
            return this.outStream;
        }

        @Override
        public boolean isDisableHistory() {
            return this.disableHistory;
        }

        @Override
        public boolean isOutputRedefined() {
            return this.outputRedefined;
        }

        @Override
        public File getHistoryFile() {
            return this.historyFile;
        }

        @Override
        public int getHistorySize() {
            return this.historySize;
        }

        @Override
        public FileAccessPermission getPermission() {
            return this.permission;
        }

        @Override
        public Runnable getInterrupt() {
            return this.interrupt;
        }

        @Override
        public boolean isOutputPaging() {
            return this.outputPaging;
        }
    }

    private static class CLITerminalConnection
    extends TerminalConnection {
        private final Consumer<int[]> interceptor = ints -> {
            if (isTraceEnabled) {
                LOG.tracef("Writing %s", (Object)Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
            }
            CLITerminalConnection.super.stdoutHandler().accept(ints);
        };
        private Thread connectionThread;
        private final ReadlineConsole console;

        CLITerminalConnection(Terminal terminal, ReadlineConsole console) {
            super(terminal);
            this.console = console;
        }

        public Consumer<int[]> stdoutHandler() {
            return this.interceptor;
        }

        public void setAttributes(Attributes attr) {
            if (!this.console.closed) {
                super.setAttributes(attr);
            }
        }

        public void openBlockingInterruptable() throws InterruptedException {
            this.connectionThread = new Thread(() -> {
                Thread thr = new Thread(() -> super.openBlocking(), "CLI Terminal Connection (uninterruptable)");
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "CLI Terminal Connection (interruptable)");
            this.connectionThread.start();
            this.connectionThread.join();
        }

        public void close() {
            super.close();
            if (this.connectionThread != null) {
                this.connectionThread.interrupt();
            }
        }
    }

    public static interface Settings {
        public InputStream getInStream();

        public OutputStream getOutStream();

        public boolean isDisableHistory();

        public boolean isOutputRedefined();

        public File getHistoryFile();

        public int getHistorySize();

        public FileAccessPermission getPermission();

        public Runnable getInterrupt();

        public boolean isOutputPaging();
    }
}

