/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="abstract-auth-sasl-re-order", description="")
public abstract class AbstractReorderSASLCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="mechanisms-order", required=true, completer=SecurityCommand.OptionCompleters.MechanismsCompleter.class)
    String mechanismsOrder;
    @Option(name="no-reload", hasValue=false)
    boolean noReload;

    public abstract String getSASLFactoryName(CommandContext var1) throws IOException, OperationFormatException;

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            SecurityCommand.execute(commandInvocation.getCommandContext(), this.buildRequest(commandInvocation.getCommandContext()), SecurityCommand.DEFAULT_FAILURE_CONSUMER, this.noReload);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        if (this.mechanismsOrder != null) {
            String[] mecs = this.mechanismsOrder.split(",");
            ArrayList<String> lst = new ArrayList<String>();
            for (String mec : mecs) {
                lst.add(mec.trim());
            }
            try {
                AuthSecurityBuilder builder = this.buildSecurityBuilder(context, lst);
                builder.buildRequest(context);
                return builder.getRequest();
            }
            catch (Exception ex) {
                throw new CommandFormatException(ex.getLocalizedMessage());
            }
        }
        throw new CommandFormatException("Mechanism order must be provided.");
    }

    private AuthSecurityBuilder buildSecurityBuilder(CommandContext ctx, List<String> order) throws Exception {
        String existingFactory = this.getSASLFactoryName(ctx);
        if (existingFactory == null) {
            throw new CommandFormatException("No SASL Factory to re-order.");
        }
        AuthSecurityBuilder builder = new AuthSecurityBuilder(order);
        builder.setActiveFactoryName(existingFactory);
        return builder;
    }
}

