/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;
import org.infinispan.query.remote.client.impl.JsonClientQueryResponse;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.client.impl.QueryResponse;

enum QuerySerializer {
    JSON(MediaType.APPLICATION_JSON){

        @Override
        byte[] serializeQueryRequest(RemoteQuery<?> remoteQuery, QueryRequest queryRequest) {
            Json object = Json.make((Object)queryRequest);
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }

        JsonClientQueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery<?> remoteQuery, byte[] bytesResponse) {
            Json response = Json.read((String)new String(bytesResponse, StandardCharsets.UTF_8));
            return new JsonClientQueryResponse(response);
        }
    }
    ,
    DEFAULT(MediaType.MATCH_ALL){

        @Override
        byte[] serializeQueryRequest(RemoteQuery<?> remoteQuery, QueryRequest queryRequest) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return ProtobufUtil.toByteArray((ImmutableSerializationContext)serCtx, (Object)queryRequest);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            Marshaller marshaller = remoteQuery.getCache().getRemoteCacheContainer().getMarshaller();
            try {
                return marshaller.objectToByteBuffer((Object)queryRequest);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HotRodClientException(e);
            }
        }

        QueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery<?> remoteQuery, byte[] bytesResponse) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return (QueryResponse)ProtobufUtil.fromByteArray((ImmutableSerializationContext)serCtx, (byte[])bytesResponse, QueryResponse.class);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            try {
                return (QueryResponse)marshaller.objectFromByteBuffer(bytesResponse);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new HotRodClientException(e);
            }
        }
    };

    private final MediaType mediaType;

    private QuerySerializer(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return this.mediaType.getTypeSubtype();
    }

    static QuerySerializer findByMediaType(MediaType mediaType) {
        return mediaType != null && mediaType.match(MediaType.APPLICATION_JSON) ? JSON : DEFAULT;
    }

    abstract byte[] serializeQueryRequest(RemoteQuery<?> var1, QueryRequest var2);

    abstract BaseQueryResponse<?> readQueryResponse(Marshaller var1, RemoteQuery<?> var2, byte[] var3);
}

