/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.mapping.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.OpenSearchVectorTypeMethod;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchKnnPredicate;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.backend.elasticsearch.types.mapping.impl.ElasticsearchVectorFieldTypeMappingContributor;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OpenSearch2VectorFieldTypeMappingContributor
implements ElasticsearchVectorFieldTypeMappingContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String BYTE_TYPE = "BYTE";

    @Override
    public void contribute(PropertyMapping mapping, ElasticsearchVectorFieldTypeMappingContributor.Context context) {
        mapping.setType("knn_vector");
        mapping.setDimension(context.dimension());
        if (BYTE_TYPE.equalsIgnoreCase(context.type())) {
            mapping.setDataType(BYTE_TYPE);
        }
        String resolvedVectorSimilarity = OpenSearch2VectorFieldTypeMappingContributor.resolveDefault(context.vectorSimilarity());
        OpenSearchVectorTypeMethod method = new OpenSearchVectorTypeMethod();
        method.setName("hnsw");
        method.setEngine("lucene");
        if (resolvedVectorSimilarity != null) {
            method.setSpaceType(resolvedVectorSimilarity);
        }
        if (context.m() != null || context.efConstruction() != null) {
            OpenSearchVectorTypeMethod.Parameters parameters = new OpenSearchVectorTypeMethod.Parameters();
            if (context.m() != null) {
                parameters.setM(context.m());
            }
            if (context.efConstruction() != null) {
                parameters.setEfConstruction(context.efConstruction());
            }
            method.setParameters(parameters);
        }
        mapping.setMethod(method);
    }

    @Override
    public <F> void contribute(ElasticsearchIndexValueFieldType.Builder<F> builder, ElasticsearchVectorFieldTypeMappingContributor.Context context) {
        builder.queryElementFactory(PredicateTypeKeys.KNN, new ElasticsearchKnnPredicate.OpenSearchFactory<F>(builder.codec()));
        builder.contributeAdditionalIndexSettings(settings -> settings.addKnn(true));
    }

    private static String resolveDefault(VectorSimilarity vectorSimilarity) {
        switch (vectorSimilarity) {
            case DEFAULT: {
                return null;
            }
            case L2: {
                return "l2";
            }
            case COSINE: {
                return "cosinesimil";
            }
            case DOT_PRODUCT: 
            case MAX_INNER_PRODUCT: {
                throw log.vectorSimilarityNotSupportedByOpenSearchBackend(vectorSimilarity);
            }
        }
        throw new AssertionFailure("Unexpected value for Similarity: " + vectorSimilarity);
    }
}

