/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import org.jboss.as.ee.resource.definition.ResourceDefinitionAnnotationProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;
import org.wildfly.extension.messaging.activemq.deployment.JMSDestinationDefinitionInjectionSource;

public class JMSDestinationDefinitionAnnotationProcessor
extends ResourceDefinitionAnnotationProcessor {
    private static final DotName JMS_DESTINATION_DEFINITION = DotName.createSimple((String)JMSDestinationDefinition.class.getName());
    private static final DotName JMS_DESTINATION_DEFINITIONS = DotName.createSimple((String)JMSDestinationDefinitions.class.getName());

    protected DotName getAnnotationDotName() {
        return JMS_DESTINATION_DEFINITION;
    }

    protected DotName getAnnotationCollectionDotName() {
        return JMS_DESTINATION_DEFINITIONS;
    }

    protected ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        String jndiName = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"name");
        String interfaceName = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"interfaceName");
        JMSDestinationDefinitionInjectionSource directJMSDestinationInjectionSource = new JMSDestinationDefinitionInjectionSource(jndiName, interfaceName);
        directJMSDestinationInjectionSource.setClassName(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"className"));
        directJMSDestinationInjectionSource.setResourceAdapter(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"resourceAdapter"));
        directJMSDestinationInjectionSource.setDestinationName(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"destinationName", (PropertyReplacer)propertyReplacer));
        directJMSDestinationInjectionSource.addProperties(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalStringArray((AnnotationInstance)annotationInstance, (String)"properties"), propertyReplacer);
        return directJMSDestinationInjectionSource;
    }
}

