/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.TransactionManager;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class InboundBridge {
    private final Xid xid;
    private final int timeout;

    InboundBridge(Xid xid, int timeout) throws XAException, SystemException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.<ctor>(Xid=" + String.valueOf(xid) + ")"));
        this.xid = xid;
        this.timeout = timeout;
        this.getTransaction();
    }

    public Xid getXid() {
        return this.xid;
    }

    public void start() throws XAException, SystemException, InvalidTransactionException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.start(Xid=" + String.valueOf(this.xid) + ")"));
        Transaction tx = this.getTransaction();
        TransactionManager.transactionManager().resume(tx);
    }

    public void stop() throws XAException, SystemException, InvalidTransactionException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.stop(" + String.valueOf(this.xid) + ")"));
        TransactionManager.transactionManager().suspend();
    }

    public void setRollbackOnly() throws XAException, SystemException {
        txbridgeLogger.logger.trace((Object)("InboundBridge.setRollbackOnly(" + String.valueOf(this.xid) + ")"));
        this.getTransaction().setRollbackOnly();
    }

    private Transaction getTransaction() throws XAException, SystemException {
        int importingTimeout = this.timeout > 0 ? this.timeout : TxControl.getDefaultTimeout();
        SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(this.xid, importingTimeout);
        switch (tx.getStatus()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Transaction not in state ACTIVE");
            }
        }
        return tx;
    }
}

